Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.41/js/thunks/nextPage.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/evaluation.es', '../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = nextPage;

    var _eventTypes = require("../actions/eventTypes.es");

    var _evaluation = require("../util/evaluation.es");

    var _visitors = require("../util/visitors.es");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function nextPage(_ref) {
      var activePage = _ref.activePage,
          defaultLanguageId = _ref.defaultLanguageId,
          editingLanguageId = _ref.editingLanguageId,
          formId = _ref.formId,
          pages = _ref.pages,
          portletNamespace = _ref.portletNamespace,
          rules = _ref.rules;
      return function (dispatch) {
        (0, _evaluation.evaluate)(null, {
          defaultLanguageId: defaultLanguageId,
          editingLanguageId: editingLanguageId,
          pages: pages,
          portletNamespace: portletNamespace,
          rules: rules
        }).then(function (evaluatedPages) {
          var validPage = true;
          var visitor = new _visitors.PagesVisitor(evaluatedPages);
          visitor.mapFields(function (_ref2, fieldIndex, columnIndex, rowIndex, pageIndex) {
            var valid = _ref2.valid;

            if (activePage === pageIndex && !valid) {
              validPage = false;
            }
          }, true, true);

          if (validPage) {
            var nextActivePageIndex = evaluatedPages.findIndex(function (_ref3, index) {
              var enabled = _ref3.enabled;
              return enabled && index > activePage;
            });
            var activePageUpdated = Math.min(nextActivePageIndex, pages.length - 1);
            dispatch({
              payload: activePageUpdated,
              type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
            });
            Liferay.fire('ddmFormPageShow', {
              formId: formId,
              page: activePageUpdated,
              title: pages[activePageUpdated].title
            });
          } else {
            dispatch({
              payload: {
                newPages: evaluatedPages,
                pageIndex: activePage
              },
              type: _eventTypes.EVENT_TYPES.PAGE_VALIDATION_FAILED
            });
          }
        });
      };
    }
    //# sourceMappingURL=nextPage.es.js.map
  }
});
//# sourceMappingURL=nextPage.es.js.map