Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.41/js/components/PageRenderer/DefaultVariant.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../hooks/useDrop.es', '../Field/ParentFieldContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.Rows = exports.Row = exports.Placeholder = exports.PageHeader = exports.Page = exports.Column = exports.Container = void 0;

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _useDrop4 = require("../../hooks/useDrop.es");

    var _ParentFieldContext = require("../Field/ParentFieldContext.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    var Container = function Container(_ref) {
      var activePage = _ref.activePage,
          children = _ref.children,
          _ref$isBuilder = _ref.isBuilder,
          isBuilder = _ref$isBuilder === void 0 ? true : _ref$isBuilder,
          pageIndex = _ref.pageIndex;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('fade tab-pane', {
            'active show': activePage === pageIndex,
            hide: activePage !== pageIndex
          }),
          role: "tabpanel"
        }, isBuilder ? /*#__PURE__*/_react.default.createElement("div", {
          className: "form-builder-layout"
        }, children) : children)
      );
    };

    exports.Container = Container;

    var Column = function Column(_ref2) {
      var _column$fields$;

      var activePage = _ref2.activePage,
          allowNestedFields = _ref2.allowNestedFields,
          children = _ref2.children,
          column = _ref2.column,
          editable = _ref2.editable,
          index = _ref2.index,
          pageIndex = _ref2.pageIndex,
          rowIndex = _ref2.rowIndex;
      var parentField = (0, _react.useContext)(_ParentFieldContext.ParentFieldContext);

      var _useDrop = (0, _useDrop4.useDrop)({
        columnIndex: index,
        fieldName: (_column$fields$ = column.fields[0]) === null || _column$fields$ === void 0 ? void 0 : _column$fields$.fieldName,
        origin: _useDrop4.DND_ORIGIN_TYPE.FIELD,
        pageIndex: pageIndex,
        parentField: parentField,
        rowIndex: rowIndex
      }),
          drop = _useDrop.drop,
          overTarget = _useDrop.overTarget;

      if (column.fields.length === 0 && editable && activePage === pageIndex) {
        return (/*#__PURE__*/_react.default.createElement(Placeholder, {
            columnIndex: index,
            pageIndex: pageIndex,
            rowIndex: rowIndex,
            size: column.size
          })
        );
      }

      var addr = {
        'data-ddm-field-column': index,
        'data-ddm-field-page': pageIndex,
        'data-ddm-field-row': rowIndex
      };

      var renderFields = function renderFields() {
        var _parentField$root;

        var firstField = column.fields[0];
        var rootParentField = (_parentField$root = parentField.root) !== null && _parentField$root !== void 0 ? _parentField$root : firstField;
        var isFieldSetOrGroup = firstField.type === 'fieldset';
        var isFieldSet = isFieldSetOrGroup && firstField.ddmStructureId;
        return (/*#__PURE__*/_react.default.createElement("div", {
            className: (0, _classnames.default)('ddm-field-container ddm-target h-100', {
              'active-drop-child': isFieldSetOrGroup && overTarget && !rootParentField.ddmStructureId,
              'ddm-fieldset': isFieldSet,
              'fields-group': isFieldSetOrGroup,
              selected: firstField.selected,
              'target-over targetOver': !rootParentField.ddmStructureId && overTarget
            }),
            "data-field-name": firstField.fieldName
          }, /*#__PURE__*/_react.default.createElement("div", _extends({
            className: (0, _classnames.default)('ddm-resize-handle ddm-resize-handle-left', {
              hide: !(firstField.hovered || firstField.selected)
            })
          }, addr)), /*#__PURE__*/_react.default.createElement("div", {
            className: (0, _classnames.default)('ddm-drag', {
              'py-0': isFieldSetOrGroup
            }),
            ref: allowNestedFields && !rootParentField.ddmStructureId ? drop : undefined
          }, column.fields.map(function (field, index) {
            return children({
              field: field,
              index: index
            });
          })), /*#__PURE__*/_react.default.createElement("div", _extends({
            className: (0, _classnames.default)('ddm-resize-handle ddm-resize-handle-right', {
              hide: !(firstField.hovered || firstField.selected)
            })
          }, addr)))
        );
      };

      return (/*#__PURE__*/_react.default.createElement(_layout.default.Col, _extends({}, addr, {
          className: "col-ddm",
          key: index,
          md: column.size
        }), column.fields.length > 0 && renderFields())
      );
    };

    exports.Column = Column;

    var Page = function Page(_ref3) {
      var activePage = _ref3.activePage,
          children = _ref3.children,
          editable = _ref3.editable,
          empty = _ref3.empty,
          forceAriaUpdate = _ref3.forceAriaUpdate,
          Header = _ref3.header,
          invalidFormMessage = _ref3.invalidFormMessage,
          pageIndex = _ref3.pageIndex;

      var _useDrop2 = (0, _useDrop4.useDrop)({
        columnIndex: 0,
        origin: _useDrop4.DND_ORIGIN_TYPE.EMPTY,
        pageIndex: pageIndex,
        rowIndex: 0
      }),
          canDrop = _useDrop2.canDrop,
          drop = _useDrop2.drop,
          overTarget = _useDrop2.overTarget;

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "active ddm-form-page lfr-ddm-form-page",
          "data-ddm-page": pageIndex
        }, invalidFormMessage && /*#__PURE__*/_react.default.createElement("span", {
          "aria-atomic": "true",
          "aria-hidden": "false",
          "aria-live": "polite",
          hidden: true
        }, invalidFormMessage, /*#__PURE__*/_react.default.createElement("span", {
          "aria-hidden": "true"
        }, forceAriaUpdate)), activePage === pageIndex && Header, empty && editable && activePage === pageIndex ? /*#__PURE__*/_react.default.createElement(_layout.default.Row, null, /*#__PURE__*/_react.default.createElement(_layout.default.Col, {
          className: "col-ddm col-empty last-col lfr-initial-col mb-4 mt-5",
          "data-ddm-field-column": "0",
          "data-ddm-field-page": pageIndex,
          "data-ddm-field-row": "0"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('ddm-empty-page ddm-target', {
            'target-droppable': canDrop,
            'target-over targetOver': overTarget
          }),
          ref: drop
        }, /*#__PURE__*/_react.default.createElement("p", {
          className: "ddm-empty-page-message"
        }, Liferay.Language.get('drag-fields-from-the-sidebar-to-compose-your-form'))))) : children)
      );
    };
    /* eslint-disable react/jsx-fragments */

    exports.Page = Page;

    var PageHeader = function PageHeader(_ref4) {
      var description = _ref4.description,
          title = _ref4.title;
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title && /*#__PURE__*/_react.default.createElement("h2", {
          className: "lfr-ddm-form-page-title"
        }, title), description && /*#__PURE__*/_react.default.createElement("h3", {
          className: "lfr-ddm-form-page-description"
        }, description))
      );
    };

    exports.PageHeader = PageHeader;

    var Placeholder = function Placeholder(_ref5) {
      var _parentField$root2, _parentField$root3;

      var columnIndex = _ref5.columnIndex,
          isRow = _ref5.isRow,
          pageIndex = _ref5.pageIndex,
          rowIndex = _ref5.rowIndex,
          size = _ref5.size;
      var parentField = (0, _react.useContext)(_ParentFieldContext.ParentFieldContext);

      var _useDrop3 = (0, _useDrop4.useDrop)({
        columnIndex: columnIndex !== null && columnIndex !== void 0 ? columnIndex : 0,
        origin: _useDrop4.DND_ORIGIN_TYPE.EMPTY,
        pageIndex: pageIndex,
        parentField: parentField,
        rowIndex: rowIndex
      }),
          drop = _useDrop3.drop,
          overTarget = _useDrop3.overTarget;

      var Content = /*#__PURE__*/_react.default.createElement(_layout.default.Col, {
        className: "col col-ddm col-empty",
        "data-ddm-field-column": columnIndex,
        "data-ddm-field-page": pageIndex,
        "data-ddm-field-row": rowIndex,
        md: size
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: (0, _classnames.default)('ddm-target', {
          'target-over targetOver': overTarget && !((_parentField$root2 = parentField.root) === null || _parentField$root2 === void 0 ? void 0 : _parentField$root2.ddmStructureId)
        }),
        ref: !((_parentField$root3 = parentField.root) === null || _parentField$root3 === void 0 ? void 0 : _parentField$root3.ddmStructureId) ? drop : undefined
      }));

      if (isRow) {
        return (/*#__PURE__*/_react.default.createElement("div", {
            className: "placeholder row"
          }, Content)
        );
      }

      return Content;
    };

    exports.Placeholder = Placeholder;

    var Row = function Row(_ref6) {
      var children = _ref6.children,
          index = _ref6.index,
          row = _ref6.row;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "position-relative row",
          key: index
        }, row.columns.map(function (column, index) {
          return children({
            column: column,
            index: index
          });
        }))
      );
    };

    exports.Row = Row;

    var Rows = function Rows(_ref7) {
      var activePage = _ref7.activePage,
          children = _ref7.children,
          editable = _ref7.editable,
          pageIndex = _ref7.pageIndex,
          rows = _ref7.rows;

      if (!rows) {
        return null;
      }

      return rows.map(function (row, index) {
        return (/*#__PURE__*/_react.default.createElement("div", {
            key: index
          }, index === 0 && editable && activePage === pageIndex && /*#__PURE__*/_react.default.createElement(Placeholder, {
            isRow: true,
            pageIndex: pageIndex,
            rowIndex: 0,
            size: 12
          }), children({
            index: index,
            row: row
          }), editable && activePage === pageIndex && /*#__PURE__*/_react.default.createElement(Placeholder, {
            isRow: true,
            pageIndex: pageIndex,
            rowIndex: index + 1,
            size: 12
          }))
        );
      });
    };

    exports.Rows = Rows;
    //# sourceMappingURL=DefaultVariant.es.js.map
  }
});
//# sourceMappingURL=DefaultVariant.es.js.map