/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import React from 'react';

import Pages from '../components/Pages.es';
import {FormNoopProvider} from '../hooks/useForm.es';

/**
 * It is an implementation of Form no-op, it just renders the
 * layout and propagates any event to the instance `dispatch`.
 */
export const FormNoop = React.forwardRef(({instance, ...otherProps}, ref) => (
	<FormNoopProvider
		onEvent={(type, payload) => instance?.context.dispatch(type, payload)}
	>
		<Pages {...otherProps} ref={ref} />
	</FormNoopProvider>
));

FormNoop.displayName = 'FormNoop';
