/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import React, {useLayoutEffect, useRef, useState} from 'react';

import {usePage} from '../hooks/usePage.es';

export const AutoFocus = ({children}) => {
	const childRef = useRef();
	const {activePage, containerElement} = usePage();
	const [increment, setIncrement] = useState(0);

	useLayoutEffect(() => {
		if (childRef.current && containerElement?.current) {
			if (childRef.current.querySelector('.loading-animation')) {

				/**
				 * This hack is to update the variable increment and cause one
				 * more render until all loadings are removed from the screen
				 * and so the field will be ready to focus
				 */

				setTimeout(() => setIncrement((value) => value + 1), 5);
			}
			else {
				const firstInput = childRef.current.querySelector('input');

				if (
					firstInput &&
					!containerElement.current.contains(document.activeElement)
				) {
					firstInput.focus();

					if (firstInput.select) {
						firstInput.select();
					}
				}
			}
		}
	}, [activePage, childRef, containerElement, increment]);

	return React.cloneElement(children, {
		ref: (node) => {
			childRef.current = node;
		},
	});
};
