Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.33/js/thunks/pageLanguageUpdate.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'frontend-js-web', '../actions/eventTypes.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = pageLanguageUpdate;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _frontendJsWeb = require("frontend-js-web");

  var _eventTypes = require("../actions/eventTypes.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var formatDataRecord = function formatDataRecord(languageId, pages, preserveValue) {
    var dataRecordValues = {};
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);

    var setDataRecord = function setDataRecord(_ref) {
      var fieldName = _ref.fieldName,
          localizable = _ref.localizable,
          localizedValue = _ref.localizedValue,
          repeatable = _ref.repeatable,
          type = _ref.type,
          value = _ref.value,
          visible = _ref.visible;

      if (type === 'fieldset') {
        return;
      }

      var _value = value;

      if (!visible) {
        _value = '';
      }

      if (localizable) {
        if (!dataRecordValues[fieldName]) {
          if (preserveValue) {
            dataRecordValues[fieldName] = _objectSpread({}, localizedValue, _defineProperty({}, languageId, []));
          } else {
            dataRecordValues[fieldName] = _objectSpread(_defineProperty({}, languageId, []), localizedValue);
          }
        }

        if (repeatable) {
          dataRecordValues[fieldName][languageId].push(_value);
        } else {
          dataRecordValues[fieldName] = _objectSpread({}, localizedValue, _defineProperty({}, languageId, _value));
        }

        if (preserveValue) {
          Object.keys(dataRecordValues[fieldName]).forEach(function (key) {
            dataRecordValues[fieldName][key] = dataRecordValues[fieldName][languageId];
          });
        }
      } else {
        dataRecordValues[fieldName] = _value;
      }
    };

    visitor.mapFields(function (field) {
      setDataRecord(field);
    }, true, true);
    return dataRecordValues;
  };

  var getDataRecordValues = function getDataRecordValues(_ref2) {
    var nextEditingLanguageId = _ref2.nextEditingLanguageId,
        pages = _ref2.pages,
        preserveValue = _ref2.preserveValue,
        prevDataRecordValues = _ref2.prevDataRecordValues,
        prevEditingLanguageId = _ref2.prevEditingLanguageId;

    if (preserveValue) {
      return formatDataRecord(nextEditingLanguageId, pages, true);
    }

    var dataRecordValues = formatDataRecord(prevEditingLanguageId, pages);

    var newDataRecordValues = _objectSpread({}, prevDataRecordValues);

    Object.keys(dataRecordValues).forEach(function (key) {
      if (newDataRecordValues[key]) {
        newDataRecordValues[key][prevEditingLanguageId] = dataRecordValues[key][prevEditingLanguageId];
      } else {
        newDataRecordValues[key] = dataRecordValues[key];
      }
    });
    return newDataRecordValues;
  };

  function pageLanguageUpdate(_ref3) {
    var ddmStructureLayoutId = _ref3.ddmStructureLayoutId,
        nextEditingLanguageId = _ref3.nextEditingLanguageId,
        pages = _ref3.pages,
        portletNamespace = _ref3.portletNamespace,
        preserveValue = _ref3.preserveValue,
        prevDataRecordValues = _ref3.prevDataRecordValues,
        prevEditingLanguageId = _ref3.prevEditingLanguageId;
    return function (dispatch) {
      var newDataRecordValues = getDataRecordValues({
        nextEditingLanguageId: nextEditingLanguageId,
        pages: pages,
        preserveValue: preserveValue,
        prevDataRecordValues: prevDataRecordValues,
        prevEditingLanguageId: prevEditingLanguageId
      });
      (0, _frontendJsWeb.fetch)("/o/data-engine/v2.0/data-layouts/".concat(ddmStructureLayoutId, "/context"), {
        body: JSON.stringify({
          dataRecordValues: newDataRecordValues,
          namespace: portletNamespace,
          pathThemeImages: themeDisplay.getPathThemeImages(),
          readOnly: false
        }),
        headers: {
          'Accept-Language': nextEditingLanguageId.replace('_', '-'),
          'Content-Type': 'application/json'
        },
        method: 'POST'
      }).then(function (response) {
        return response.json();
      }).then(function (_ref4) {
        var pages = _ref4.pages;
        var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
        var newPages = visitor.mapFields(function (field, index) {
          if (!field.localizedValue) {
            field.localizedValue = {};
          }

          if (field.repeatable) {
            var values = {};
            Object.keys(newDataRecordValues[field.fieldName]).forEach(function (key) {
              values = _objectSpread({}, values, _defineProperty({}, key, newDataRecordValues[field.fieldName][key][index]));
            });
            field.localizedValue = values;
          } else if (newDataRecordValues[field.fieldName]) {
            field.localizedValue = _objectSpread({}, newDataRecordValues[field.fieldName]);
          }

          return field;
        }, true, true);
        dispatch({
          payload: {
            editingLanguageId: nextEditingLanguageId,
            pages: newPages
          },
          type: _eventTypes.EVENT_TYPES.ALL
        });
        dispatch({
          payload: newDataRecordValues,
          type: _eventTypes.EVENT_TYPES.UPDATE_DATA_RECORD_VALUES
        });
      });
    };
  }
  //# sourceMappingURL=pageLanguageUpdate.es.js.map
});
//# sourceMappingURL=pageLanguageUpdate.es.js.map