Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.33/js/thunks/formValidate.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/evaluation.es', '../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = formValidate;

  var _eventTypes = require("../actions/eventTypes.es");

  var _evaluation = require("../util/evaluation.es");

  var _visitors = require("../util/visitors.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  function formValidate(_ref) {
    var activePage = _ref.activePage,
        defaultLanguageId = _ref.defaultLanguageId,
        editingLanguageId = _ref.editingLanguageId,
        pages = _ref.pages,
        portletNamespace = _ref.portletNamespace,
        rules = _ref.rules;
    return function (dispatch) {
      return (0, _evaluation.evaluate)(null, {
        defaultLanguageId: defaultLanguageId,
        editingLanguageId: editingLanguageId,
        pages: pages,
        portletNamespace: portletNamespace,
        rules: rules
      }).then(function (evaluatedPages) {
        var validForm = true;
        var visitor = new _visitors.PagesVisitor(evaluatedPages);
        visitor.mapFields(function (_ref2) {
          var valid = _ref2.valid;

          if (!valid) {
            validForm = false;
          }
        }, true, true);

        if (!validForm) {
          dispatch({
            payload: {
              newPages: evaluatedPages,
              pageIndex: activePage
            },
            type: _eventTypes.EVENT_TYPES.PAGE_VALIDATION_FAILED
          });
        }

        return Promise.resolve(validForm);
      });
    };
  }
  //# sourceMappingURL=formValidate.es.js.map
});
//# sourceMappingURL=formValidate.es.js.map