Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.33/js/reducers/index.es", ['module', 'exports', 'require', './defaultReducer.es', './fieldReducer.es', './pageReducer.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.createReducer = void 0;

  var _defaultReducer = _interopRequireDefault(require("./defaultReducer.es"));

  var _fieldReducer = _interopRequireDefault(require("./fieldReducer.es"));

  var _pageReducer = _interopRequireDefault(require("./pageReducer.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var reducers = [_defaultReducer["default"], _fieldReducer["default"], _pageReducer["default"]];
  var hasSentEvent = false;

  var createReducer = function createReducer(onEvent) {
    return function (state, action) {
      return reducers.reduce(function (prevState, reducer, index) {
        var nextProperties = reducer(prevState, action);

        if (prevState === nextProperties) {
          // We only propagate the event when no event has been handled
          // before and we are at the last interaction of the reducers,
          // this ensures that we do not send unnecessary events.
          if (index === reducers.length - 1 && !hasSentEvent) {
            hasSentEvent = true;
            onEvent(action.type, action.payload);
          }

          return nextProperties;
        } // The reducer propagates the events so that they can be
        // handled by other components in the upper layer that are
        // not the responsibility of the form renderer, some
        // operations are transformed and treated here, we issue
        // the final result to avoid double operations that are
        // costly.


        hasSentEvent = false;
        onEvent(action.type, _objectSpread({
          transformation: nextProperties
        }, _typeof(action.payload) === 'object' ? action.payload : {
          value: action.payload
        }));
        return _objectSpread({}, prevState, {}, nextProperties);
      }, state);
    };
  };

  exports.createReducer = createReducer;
  //# sourceMappingURL=index.es.js.map
});
//# sourceMappingURL=index.es.js.map