Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.33/js/components/PageRenderer/MultiPagesVariant.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$react', '../../actions/eventTypes.es', '../../hooks/useForm.es', '../../hooks/usePage.es', './DefaultVariant.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Rows = exports.Page = exports.Container = void 0;

  var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

  var _dropDown = require("@frontend-taglib-clay$clayui/drop-down");

  var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

  var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _eventTypes = require("../../actions/eventTypes.es");

  var _useForm = require("../../hooks/useForm.es");

  var _usePage2 = require("../../hooks/usePage.es");

  var _DefaultVariant = require("./DefaultVariant.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  /* eslint-disable react/jsx-fragments */
  var Container = function Container(_ref) {
    var children = _ref.children,
        empty = _ref.empty,
        page = _ref.page,
        pageIndex = _ref.pageIndex,
        pages = _ref.pages;

    var _usePage = (0, _usePage2.usePage)(),
        editingLanguageId = _usePage.editingLanguageId,
        successPageSettings = _usePage.successPageSettings;

    var dispatch = (0, _useForm.useForm)();
    var pageSettingsItems = [empty ? {
      className: 'ddm-btn-disabled',
      disabled: true,
      label: Liferay.Language.get('reset-page')
    } : {
      label: Liferay.Language.get('reset-page'),
      onClick: function onClick() {
        return dispatch({
          payload: {
            pageIndex: pageIndex
          },
          type: _eventTypes.EVENT_TYPES.PAGE_RESET
        });
      }
    }, pageIndex > 0 ? {
      label: Liferay.Language.get('remove-page'),
      onClick: function onClick() {
        return dispatch({
          payload: pageIndex,
          type: _eventTypes.EVENT_TYPES.PAGE_DELETED
        });
      }
    } : false].filter(Boolean);

    return _react["default"].createElement(_react["default"].Fragment, null, pageIndex === 0 && _react["default"].createElement("div", {
      className: "horizontal-line"
    }), _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement("div", {
      className: "page"
    }, _react["default"].createElement(_layout["default"].Sheet, {
      className: "fade show tab-pane",
      role: "tabpanel"
    }, _react["default"].createElement("div", {
      className: "form-builder-layout"
    }, _react["default"].createElement("h5", {
      className: "pagination"
    }, page.pagination), children)), _react["default"].createElement("div", {
      className: "ddm-paginated-builder-reorder"
    }, _react["default"].createElement(_button.ClayButtonWithIcon, {
      className: "reorder-page-button",
      disabled: pageIndex === 0,
      displayType: "secondary",
      onClick: function onClick() {
        return dispatch({
          payload: {
            firstIndex: pageIndex,
            secondIndex: pageIndex - 1
          },
          type: _eventTypes.EVENT_TYPES.PAGE_SWAPPED
        });
      },
      small: true,
      symbol: "angle-up",
      title: Liferay.Language.get('move-page-up')
    }), _react["default"].createElement(_button.ClayButtonWithIcon, {
      className: "reorder-page-button",
      disabled: pageIndex === pages.length - ((successPageSettings === null || successPageSettings === void 0 ? void 0 : successPageSettings.enabled) ? 2 : 1),
      displayType: "secondary",
      onClick: function onClick() {
        return dispatch({
          payload: {
            firstIndex: pageIndex,
            secondIndex: pageIndex + 1
          },
          type: _eventTypes.EVENT_TYPES.PAGE_SWAPPED
        });
      },
      small: true,
      symbol: "angle-down",
      title: Liferay.Language.get('move-page-down')
    })), _react["default"].createElement("div", {
      className: "ddm-paginated-builder-dropdown"
    }, _react["default"].createElement(_dropDown.ClayDropDownWithItems, {
      className: "dropdown-action",
      items: pageSettingsItems,
      trigger: _react["default"].createElement(_button.ClayButtonWithIcon, {
        displayType: "unstyled",
        symbol: "ellipsis-v",
        title: Liferay.Language.get('page-options')
      })
    })), _react["default"].createElement("div", {
      className: "add-page-button-container"
    }, _react["default"].createElement("div", {
      className: "horizontal-line"
    }), _react["default"].createElement(_button["default"], {
      className: "add-page-button",
      displayType: "secondary",
      onClick: function onClick() {
        return dispatch({
          payload: {
            pageIndex: pageIndex
          },
          type: _eventTypes.EVENT_TYPES.PAGE_ADDED
        });
      },
      small: true
    }, Liferay.Language.get('new-page')), _react["default"].createElement("div", {
      className: "horizontal-line"
    })), pages.length - 1 === pageIndex && _react["default"].createElement("div", {
      className: "add-page-button-container"
    }, _react["default"].createElement("div", {
      className: "horizontal-line"
    }), _react["default"].createElement(_button["default"], {
      className: "add-page-button",
      displayType: "secondary",
      onClick: function onAddSuccessPage() {
        var successPageSettings = {
          body: _defineProperty({}, editingLanguageId, Liferay.Language.get('your-information-was-successfully-received-thank-you-for-filling-out-the-form')),
          enabled: true,
          title: _defineProperty({}, editingLanguageId, Liferay.Language.get('thank-you'))
        };
        dispatch({
          payload: successPageSettings,
          type: _eventTypes.EVENT_TYPES.SUCCESS_CHANGED
        });
        dispatch({
          payload: pages.length,
          type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
        });
      },
      small: true
    }, Liferay.Language.get('add-success-page')), _react["default"].createElement("div", {
      className: "horizontal-line"
    })))));
  };

  exports.Container = Container;

  var Page = function Page(_ref2) {
    var children = _ref2.children,
        editable = _ref2.editable,
        empty = _ref2.empty,
        Header = _ref2.header,
        pageIndex = _ref2.pageIndex;
    return _react["default"].createElement("div", {
      className: "active ddm-form-page lfr-ddm-form-page",
      "data-ddm-page": pageIndex
    }, Header, empty && editable ? _react["default"].createElement(_layout["default"].Row, null, _react["default"].createElement(_layout["default"].Col, {
      className: "col-ddm col-empty last-col lfr-initial-col mb-4 mt-5",
      "data-ddm-field-column": "0",
      "data-ddm-field-page": pageIndex,
      "data-ddm-field-row": "0"
    }, _react["default"].createElement("div", {
      className: "ddm-empty-page ddm-target"
    }, _react["default"].createElement("p", {
      className: "ddm-empty-page-message"
    }, Liferay.Language.get('drag-fields-from-the-sidebar-to-compose-your-form'))))) : children);
  };

  exports.Page = Page;

  var Rows = function Rows(_ref3) {
    var children = _ref3.children,
        editable = _ref3.editable,
        pageIndex = _ref3.pageIndex,
        rows = _ref3.rows;

    if (!rows) {
      return null;
    }

    return rows.map(function (row, index) {
      return _react["default"].createElement("div", {
        key: index
      }, index === 0 && editable && _react["default"].createElement(_DefaultVariant.Placeholder, {
        isRow: true,
        pageIndex: pageIndex,
        rowIndex: 0,
        size: 12
      }), children({
        index: index,
        row: row
      }), editable && _react["default"].createElement(_DefaultVariant.Placeholder, {
        isRow: true,
        pageIndex: pageIndex,
        rowIndex: index + 1,
        size: 12
      }));
    });
  };

  exports.Rows = Rows;
  //# sourceMappingURL=MultiPagesVariant.es.js.map
});
//# sourceMappingURL=MultiPagesVariant.es.js.map