/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {EVENT_TYPES} from '../actions/eventTypes.es';
import {PagesVisitor} from '../util/visitors.es';

export default (state, action) => {
	switch (action.type) {
		case EVENT_TYPES.ALL: {
			const {defaultLanguageId} = state;
			const {editingLanguageId, pages} = action.payload;

			if (
				editingLanguageId &&
				state.editingLanguageId !== editingLanguageId
			) {
				const visitor = new PagesVisitor(pages ?? state.pages);

				return {
					...action.payload,
					pages: visitor.mapFields(
						({localizedValue}) => {
							let value;

							if (localizedValue) {
								if (
									localizedValue[editingLanguageId] !==
									undefined
								) {
									value = localizedValue[editingLanguageId];
								}
								else if (localizedValue[defaultLanguageId]) {
									value = localizedValue[defaultLanguageId];
								}
							}

							return {
								value,
							};
						},
						true,
						true,
						true
					),
				};
			}

			return action.payload;
		}
		case EVENT_TYPES.UPDATE_DATA_RECORD_VALUES:
			return {
				dataRecordValues: action.payload,
			};
		default:
			return state;
	}
};
