/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {useThunk} from 'frontend-js-react-web';
import React, {useContext, useEffect, useReducer} from 'react';

import {EVENT_TYPES} from '../actions/eventTypes.es';
import {createReducer} from '../reducers/index.es';

const FormContext = React.createContext(() => {});

FormContext.displayName = 'FormContext';

export const FormNoopProvider = ({children, onEvent}) => {
	const [, dispatch] = useThunk([
		{},
		({payload, type}) => onEvent(type, payload),
	]);

	return (
		<FormContext.Provider value={dispatch}>{children}</FormContext.Provider>
	);
};

export const FormProvider = ({children, onEvent, value}) => {
	const [state, dispatch] = useThunk(
		useReducer(createReducer(onEvent), value)
	);

	useEffect(() => dispatch({payload: value, type: EVENT_TYPES.ALL}), [
		dispatch,
		value,
	]);

	return (
		<FormContext.Provider value={dispatch}>
			{children(state)}
		</FormContext.Provider>
	);
};

export const useForm = () => {
	return useContext(FormContext);
};
