/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import React from 'react';

export const PageHeader = ({description, placeholder, title}) => (
	<div>
		<input
			className="form-builder-page-header-title form-control p-0"
			defaultValue={title}
			maxLength="120"
			placeholder={placeholder}
			value={title}
		/>
		<input
			className="form-builder-page-header-description form-control p-0"
			defaultValue={description}
			maxLength="120"
			placeholder={Liferay.Language.get(
				'add-a-short-description-for-this-page'
			)}
			value={description}
		/>
	</div>
);
