/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import classnames from 'classnames';
import React from 'react';

import {EVENT_TYPES} from '../actions/eventTypes.es';
import {useForm} from '../hooks/useForm.es';

export const MultiStep = ({activePage, editable, pages}) => {
	const dispatch = useForm();

	return (
		<div className="ddm-form-pagination position-relative wizard-mode">
			<ol className="dmm-wizard multi-step-indicator-label-top multi-step-nav multi-step-nav-collapse-sm">
				{pages.map((page, index) => (
					<li
						className={classnames('multi-step-item', {
							active: index === activePage,
							complete: index < activePage,
							'multi-step-item-expand':
								index + 1 !== pages.length,
						})}
						key={index}
						onClick={() =>
							dispatch({
								payload: index,
								type: EVENT_TYPES.CHANGE_ACTIVE_PAGE,
							})
						}
					>
						<div className="multi-step-divider"></div>
						<div className="multi-step-indicator">
							<div className="multi-step-indicator-label">
								{page.paginationItemRenderer ===
								'wizard_success'
									? Liferay.Language.get('success-page')
									: page.title
									? page.title
									: Liferay.Language.get('untitled-page')}
							</div>

							{editable ? (
								<a
									className="multi-step-icon"
									data-multi-step-icon={index + 1}
									href="javascript:;"
								/>
							) : (
								<span
									className="multi-step-icon"
									data-multi-step-icon={index + 1}
								/>
							)}
						</div>
					</li>
				))}
			</ol>
		</div>
	);
};
