/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import Component from 'metal-component';
import Soy from 'metal-soy';
import {Config} from 'metal-state';

import templates from './MetalFieldAdapter.soy';

class MetalFieldAdapter extends Component {
	getChildContext() {
		return {
			dispatch: this._handleDispatch.bind(this),
			store: {
				editingLanguageId: this.editingLanguageId,
			},
		};
	}

	_handleDispatch(name, event) {
		switch (name) {
			case 'fieldRemoved':
				this.onRemoved(name, event);
				break;
			case 'fieldRepeated':
				this.onRepeated(name, event);
				break;
			default:
				new TypeError(`${name} event is not supported.`);
				break;
		}
	}

	_handleFieldBlurred(event) {

		// Sends the empty value, the `blur` event does not need to
		// know this information only that the event was triggered.

		this.onBlur(event, '');
	}

	_handleFieldEdited(event) {
		const {originalEvent, value} = event;
		this.onChange(originalEvent, value);
	}

	_handleFieldFocused(event) {

		// Sends the empty value, the `focus` event does not need to
		// know this information only that the event was triggered.

		this.onFocus(event, '');
	}
}

MetalFieldAdapter.STATE = {
	activePage: Config.number(),
	editable: Config.bool(),
	editingLanguageId: Config.string(),
	field: Config.any(),
	onBlur: Config.any(),
	onChange: Config.any(),
	onFocus: Config.any(),
	onRemoved: Config.any(),
	onRepeated: Config.any(),
	pageIndex: Config.number(),
	spritemap: Config.string(),
	type: Config.string(),
};

Soy.register(MetalFieldAdapter, templates);

export default MetalFieldAdapter;
