/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

const PUBLIC_EVENTS = {
	CHANGE_ACTIVE_PAGE: 'activePageUpdated',
	FIELD_BLUR: 'fieldBlurred',
	FIELD_CHANGE: 'fieldEdited',
	FIELD_DROP: 'fieldDrop',
	FIELD_EVALUATED: 'evaluated',
	FIELD_EVALUATION_ERROR: 'evaluationError',
	FIELD_FOCUS: 'fieldFocused',
	FIELD_REMOVED: 'fieldRemoved',
	FIELD_REPEATED: 'fieldRepeated',
	PAGE_ADDED: 'pageAdded',
	PAGE_DELETED: 'pageDeleted',
	PAGE_RESET: 'pageReset',
	PAGE_SWAPPED: 'pagesSwapped',
	PAGE_VALIDATION_FAILED: 'pageValidationFailed',
	SUCCESS_CHANGED: 'successPageChanged',
};

const PRIVATE_EVENTS = {
	ALL: 'all',
	UPDATE_DATA_RECORD_VALUES: 'update_data_record_values',
	UPDATE_PAGES: 'update_pages',
};

export const EVENT_TYPES = {
	...PUBLIC_EVENTS,
	...PRIVATE_EVENTS,
};
