/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

// Utils

export {default as compose} from './js/util/compose.es';
export {normalizeFieldName} from './js/util/fields.es';
export {
	getRepeatedIndex,
	generateName,
	generateInstanceId,
} from './js/util/repeatable.es';
export {PagesVisitor, RulesVisitor} from './js/util/visitors.es';
export * as FormSupport from './js/util/FormSupport.es';
export {getConnectedReactComponentAdapter} from './js/util/ReactComponentAdapter.es';

// Composing Form

export {default as Pages} from './js/components/Pages.es';
export {EVENT_TYPES} from './js/actions/eventTypes.es';
export {PageProvider, usePage} from './js/hooks/usePage.es';
export {FormProvider, FormNoopProvider, useForm} from './js/hooks/useForm.es';
export {Layout} from './js/components/PageRenderer/Layout.es';
export * as DefaultVariant from './js/components/PageRenderer/DefaultVariant.es';

// Containers

export {default as Form} from './js/containers/Form.es';
export {FormNoop} from './js/containers/FormNoop.es';
