Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.27/js/containers/Form.es", ['module', 'exports', 'require', '../../css/main.scss', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-soy', 'frontend-js-react-web$react', '../actions/eventTypes.es', '../components/Pages.es', '../hooks/useForm.es', '../thunks/formValidate.es', '../util/ReactComponentAdapter.es', '../util/evaluation.es', '../util/formId.es', './Form.soy'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  require("../../css/main.scss");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _eventTypes = require("../actions/eventTypes.es");

  var _Pages = _interopRequireDefault(require("../components/Pages.es"));

  var _useForm = require("../hooks/useForm.es");

  var _formValidate = _interopRequireDefault(require("../thunks/formValidate.es"));

  var _ReactComponentAdapter = require("../util/ReactComponentAdapter.es");

  var _evaluation = require("../util/evaluation.es");

  var _formId = require("../util/formId.es");

  var _Form = _interopRequireDefault(require("./Form.soy"));

  var _this = void 0;

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  var Form = _react["default"].forwardRef(function (_ref, ref) {
    var activePage = _ref.activePage,
        defaultLanguageId = _ref.defaultLanguageId,
        description = _ref.description,
        editingLanguageId = _ref.editingLanguageId,
        name = _ref.name,
        pages = _ref.pages,
        paginationMode = _ref.paginationMode,
        portletNamespace = _ref.portletNamespace,
        rules = _ref.rules,
        successPageSettings = _ref.successPageSettings,
        otherProps = _objectWithoutProperties(_ref, ["activePage", "defaultLanguageId", "description", "editingLanguageId", "name", "pages", "paginationMode", "portletNamespace", "rules", "successPageSettings"]);

    var dispatch = (0, _useForm.useForm)();
    var containerRef = (0, _react.useRef)(null);
    var validate = (0, _react.useCallback)(function () {
      return dispatch((0, _formValidate["default"])({
        activePage: activePage,
        defaultLanguageId: defaultLanguageId,
        editingLanguageId: editingLanguageId,
        pages: pages,
        portletNamespace: portletNamespace,
        rules: rules
      }));
    }, [dispatch, activePage, defaultLanguageId, editingLanguageId, pages, portletNamespace, rules]);
    var handleFormSubmitted = (0, _react.useCallback)(function (event) {
      event.preventDefault();
      validate().then(function (validForm) {
        if (validForm) {
          Liferay.Util.submitForm(event.target);
          Liferay.fire('ddmFormSubmit', {
            formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerRef.current))
          });
        }
      })["catch"](function (error) {
        console.error(error);
      });
    }, [containerRef, validate]);
    (0, _react.useImperativeHandle)(ref, function () {
      return {
        evaluate: function evaluate(editingLanguageId) {
          return (0, _evaluation.evaluate)(null, {
            defaultLanguageId: defaultLanguageId,
            editingLanguageId: editingLanguageId,
            pages: pages,
            portletNamespace: portletNamespace,
            rules: rules
          });
        },
        get: function get(key) {
          var props = _objectSpread({
            activePage: activePage,
            defaultLanguageId: defaultLanguageId,
            description: description,
            editingLanguageId: editingLanguageId,
            name: name,
            pages: pages,
            paginationMode: paginationMode,
            portletNamespace: portletNamespace,
            rules: rules,
            successPageSettings: successPageSettings
          }, otherProps);

          return props[key];
        },
        getFormNode: function getFormNode() {
          return containerRef.current && (0, _formId.getFormNode)(containerRef.current);
        },
        toJSON: function toJSON() {
          return {
            defaultLanguageId: defaultLanguageId,
            description: description,
            editingLanguageId: editingLanguageId,
            name: name,
            pages: pages,
            paginationMode: paginationMode,
            portletNamespace: portletNamespace,
            rules: rules,
            successPageSettings: successPageSettings
          };
        },
        updateEditingLanguageId: function updateEditingLanguageId(_ref2) {
          var editingLanguageId = _ref2.editingLanguageId;
          return dispatch({
            payload: {
              editingLanguageId: editingLanguageId
            },
            type: _eventTypes.EVENT_TYPES.ALL
          });
        },
        validate: validate
      };
    });
    (0, _react.useEffect)(function () {
      if (containerRef.current) {
        Liferay.fire('ddmFormPageShow', {
          formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerRef.current)),
          page: activePage,
          title: pages[activePage].title
        });
      } // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    (0, _react.useEffect)(function () {
      var onHandle;
      var submitHandle;

      if (containerRef.current) {
        var form = (0, _formId.getFormNode)(containerRef.current);

        if (form) {
          onHandle = Liferay.on('submitForm', function (event) {
            if (event.form && event.form.getDOM() === form) {
              event.preventDefault();
            }
          }, _this);
          submitHandle = _metalDom["default"].on(form, 'submit', handleFormSubmitted);
        }
      }

      return function () {
        if (onHandle) {
          onHandle.detach();
        }

        if (submitHandle) {
          submitHandle.removeListener();
        }
      };
    }, [containerRef, handleFormSubmitted]);
    return _react["default"].createElement(_Pages["default"], _extends({
      activePage: activePage,
      defaultLanguageId: defaultLanguageId,
      description: description,
      editingLanguageId: editingLanguageId,
      name: name,
      pages: pages,
      paginationMode: paginationMode,
      portletNamespace: portletNamespace,
      rules: rules,
      successPageSettings: successPageSettings
    }, otherProps, {
      ref: containerRef
    }));
  });

  Form.displayName = 'Form';

  var FormProxy = _react["default"].forwardRef(function (_ref3, ref) {
    var instance = _ref3.instance,
        _ref3$activePage = _ref3.activePage,
        activePage = _ref3$activePage === void 0 ? 0 : _ref3$activePage,
        _ref3$defaultLanguage = _ref3.defaultLanguageId,
        defaultLanguageId = _ref3$defaultLanguage === void 0 ? themeDisplay.getLanguageId() : _ref3$defaultLanguage,
        otherProps = _objectWithoutProperties(_ref3, ["instance", "activePage", "defaultLanguageId"]);

    return _react["default"].createElement(_useForm.FormProvider, {
      onEvent: function onEvent(type, payload) {
        return instance.emit(type, payload);
      },
      value: _objectSpread({}, otherProps, {
        activePage: activePage,
        defaultLanguageId: defaultLanguageId
      })
    }, function (props) {
      return _react["default"].createElement(Form, _extends({}, props, {
        ref: ref
      }));
    });
  });

  FormProxy.displayName = 'FormProxy';
  var ReactFormAdapter = (0, _ReactComponentAdapter.getConnectedReactComponentAdapter)(FormProxy);

  _metalSoy["default"].register(ReactFormAdapter, _Form["default"]);

  var _default = ReactFormAdapter;
  exports["default"] = _default;
  //# sourceMappingURL=Form.es.js.map
});
//# sourceMappingURL=Form.es.js.map