Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.27/js/components/Pagination.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/pagination', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../actions/eventTypes.es', '../hooks/useEvaluate.es', '../hooks/useForm.es', '../hooks/usePage.es', '../thunks/nextPage.es', '../thunks/previousPage.es', '../util/formId.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Pagination = void 0;

  var _pagination = _interopRequireDefault(require("@frontend-taglib-clay$clayui/pagination"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _eventTypes = require("../actions/eventTypes.es");

  var _useEvaluate = require("../hooks/useEvaluate.es");

  var _useForm = require("../hooks/useForm.es");

  var _usePage2 = require("../hooks/usePage.es");

  var _nextPage = _interopRequireDefault(require("../thunks/nextPage.es"));

  var _previousPage = _interopRequireDefault(require("../thunks/previousPage.es"));

  var _formId = require("../util/formId.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var Pagination = function Pagination(_ref) {
    var activePage = _ref.activePage,
        pages = _ref.pages;
    var createPreviousPage = (0, _useEvaluate.useEvaluate)(_previousPage["default"]);
    var createNextPage = (0, _useEvaluate.useEvaluate)(_nextPage["default"]);

    var _usePage = (0, _usePage2.usePage)(),
        containerElement = _usePage.containerElement;

    var dispatch = (0, _useForm.useForm)();
    return _react["default"].createElement(_pagination["default"], {
      className: "ddm-pagination justify-content-center"
    }, _react["default"].createElement("li", {
      className: (0, _classnames["default"])('page-item', {
        'visibility-hidden': activePage === 0
      })
    }, _react["default"].createElement("button", {
      className: "page-link",
      onClick: function onClick() {
        return dispatch(createPreviousPage({
          activePage: activePage,
          formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
        }));
      },
      type: "button"
    }, "\xAB", _react["default"].createElement("span", {
      className: "sr-only"
    }, Liferay.Language.get('previous')))), pages.map(function (page, index) {
      return _react["default"].createElement(_pagination["default"].Item, {
        active: activePage === index,
        disabled: !page.enabled,
        key: index,
        onClick: function onClick() {
          return dispatch({
            payload: index,
            type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
          });
        }
      }, page.paginationItemRenderer === 'paginated_success' ? Liferay.Language.get('success-page') : index + 1);
    }), _react["default"].createElement("li", {
      className: (0, _classnames["default"])('page-item', {
        'visibility-hidden': activePage === pages.length - 1 || activePage === -1
      })
    }, _react["default"].createElement("button", {
      className: "page-link",
      onClick: function onClick() {
        return dispatch(createNextPage({
          activePage: activePage,
          formId: (0, _formId.getFormId)((0, _formId.getFormNode)(containerElement.current))
        }));
      },
      type: "button"
    }, "\xBB", _react["default"].createElement("span", {
      className: "sr-only"
    }, Liferay.Language.get('next')))));
  };

  exports.Pagination = Pagination;
  //# sourceMappingURL=Pagination.es.js.map
});
//# sourceMappingURL=Pagination.es.js.map