Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.27/js/components/PageRenderer/index", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-react-web$react', '../../hooks/usePage.es', './DefaultVariant.es', './EditablePageHeader.es', './Layout.es', './MultiPagesVariant.es', './PaginatedVariant.es', './SuccessVariant.es', './TabbedVariant.es', './WizardVariant.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _usePage = require("../../hooks/usePage.es");

  var DefaultVariant = _interopRequireWildcard(require("./DefaultVariant.es"));

  var EditablePageHeader = _interopRequireWildcard(require("./EditablePageHeader.es"));

  var _Layout = require("./Layout.es");

  var MultiPages = _interopRequireWildcard(require("./MultiPagesVariant.es"));

  var Paginated = _interopRequireWildcard(require("./PaginatedVariant.es"));

  var SuccessPage = _interopRequireWildcard(require("./SuccessVariant.es"));

  var Tabbed = _interopRequireWildcard(require("./TabbedVariant.es"));

  var Wizard = _interopRequireWildcard(require("./WizardVariant.es"));

  var _LAYOUT_COMPONENTS_TY;

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var LAYOUT_TYPES = {
    MULTI_PAGES: 'multi_pages',
    PAGINATED: 'paginated',
    SINGLE_PAGE: 'single-page',
    SUCCESS: 'success',
    TABBED: 'tabbed',
    WIZARD: 'wizard'
  };
  var LAYOUT_COMPONENTS_TYPES = (_LAYOUT_COMPONENTS_TY = {}, _defineProperty(_LAYOUT_COMPONENTS_TY, LAYOUT_TYPES.MULTI_PAGES, MultiPages), _defineProperty(_LAYOUT_COMPONENTS_TY, LAYOUT_TYPES.PAGINATED, Paginated), _defineProperty(_LAYOUT_COMPONENTS_TY, LAYOUT_TYPES.SINGLE_PAGE, {
    Container: DefaultVariant.Container
  }), _defineProperty(_LAYOUT_COMPONENTS_TY, LAYOUT_TYPES.SUCCESS, SuccessPage), _defineProperty(_LAYOUT_COMPONENTS_TY, LAYOUT_TYPES.TABBED, Tabbed), _defineProperty(_LAYOUT_COMPONENTS_TY, LAYOUT_TYPES.WIZARD, Wizard), _LAYOUT_COMPONENTS_TY);
  var PAGE_HEADER_TYPES = {
    EDITABLE: 'editable'
  };

  var PAGE_HEADER_COMPONENT_TYPE = _defineProperty({}, PAGE_HEADER_TYPES.EDITABLE, EditablePageHeader.PageHeader);

  var isEmptyPage = function isEmptyPage(_ref) {
    var rows = _ref.rows;
    var empty = false;

    if (!rows || !rows.length) {
      empty = true;
    } else {
      empty = !rows.some(function (_ref2) {
        var columns = _ref2.columns;
        var hasFields = true;

        if (!columns) {
          hasFields = false;
        } else {
          hasFields = columns.some(function (column) {
            return column.fields.length;
          });
        }

        return hasFields;
      });
    }

    return empty;
  };

  var normalizePage = function normalizePage(page, editingLanguageId) {
    if (_metal["default"].isObject(page.description)) {
      page = _objectSpread({}, page, {
        description: page.description[editingLanguageId]
      });
    }

    if (_metal["default"].isObject(page.title)) {
      page = _objectSpread({}, page, {
        title: page.title[editingLanguageId]
      });
    }

    return page;
  };

  var getVariant = function getVariant(_ref3) {
    var page = _ref3.page,
        pages = _ref3.pages,
        paginationMode = _ref3.paginationMode,
        view = _ref3.view,
        viewMode = _ref3.viewMode;

    if (page.contentRenderer && page.contentRenderer !== null && page.contentRenderer !== '') {
      return page.contentRenderer;
    } else if (paginationMode === null || paginationMode === '') {
      if (pages.length > 1) {
        return LAYOUT_TYPES.WIZARD;
      } else {
        return LAYOUT_TYPES.SINGLE_PAGE;
      }
    } else if (paginationMode === LAYOUT_TYPES.WIZARD && !viewMode && view === 'formBuilder') {
      return LAYOUT_TYPES.MULTI_PAGES;
    } else {
      return paginationMode;
    }
  };
  /**
   * Renderer is the main component for dealing with Forms `pages` structure,
   * you can use the renderer to render fields from different layouts.
   *
   * Renderer supports some rendering modes by default
   * - multi_pages
   * - paginated
   * - single-page
   * - success
   * - tabbed
   * - wizard
   *
   * You can replace all major components or just a few to change the layout
   * structure, consider the following components
   * - Container
   * - Page
   * - Rows
   * - Row
   * - Column
   *
   * Use the `overrides` API to pass the components you want to replace,
   * an example of Page.
   * <Renderer
   * 	overrides={{
   * 	  Page: ({children}) => children
   * 	}}
   * />
   */

  var Renderer = function Renderer(_ref4) {
    var _ref4$activePage = _ref4.activePage,
        activePage = _ref4$activePage === void 0 ? 0 : _ref4$activePage,
        _ref4$editable = _ref4.editable,
        editable = _ref4$editable === void 0 ? false : _ref4$editable,
        editingLanguageId = _ref4.editingLanguageId,
        _ref4$overrides = _ref4.overrides,
        overrides = _ref4$overrides === void 0 ? {} : _ref4$overrides,
        defaultPage = _ref4.page,
        _ref4$pageIndex = _ref4.pageIndex,
        pageIndex = _ref4$pageIndex === void 0 ? 0 : _ref4$pageIndex,
        pages = _ref4.pages,
        paginationMode = _ref4.paginationMode,
        readOnly = _ref4.readOnly,
        showSubmitButton = _ref4.showSubmitButton,
        strings = _ref4.strings,
        submitLabel = _ref4.submitLabel,
        view = _ref4.view,
        viewMode = _ref4.viewMode;
    var empty = isEmptyPage(defaultPage);
    var page = normalizePage(defaultPage, editingLanguageId);
    var variant = getVariant({
      page: page,
      pages: pages,
      paginationMode: paginationMode,
      view: view,
      viewMode: viewMode
    });
    var variantComponents = LAYOUT_COMPONENTS_TYPES[variant] || {};

    var Components = _objectSpread({}, DefaultVariant, {}, variantComponents, {}, overrides);

    var Header = PAGE_HEADER_COMPONENT_TYPE[page.headerRenderer] || Components.PageHeader;
    return _react["default"].createElement(Components.Container, {
      activePage: activePage,
      editable: editable,
      empty: empty,
      page: page,
      pageIndex: pageIndex,
      pages: pages,
      readOnly: readOnly,
      showSubmitButton: showSubmitButton,
      strings: strings,
      submitLabel: submitLabel
    }, _react["default"].createElement(Components.Page, {
      activePage: activePage,
      editable: editable,
      empty: empty,
      header: variant === LAYOUT_TYPES.SINGLE_PAGE ? null : _react["default"].createElement(Header, {
        description: page.description,
        placeholder: page.placeholder,
        title: page.title
      }),
      page: page,
      pageIndex: pageIndex
    }, _react["default"].createElement(_Layout.Layout, {
      components: Components,
      rows: page.rows
    })));
  };

  var _default = function _default(props) {
    return _react["default"].createElement(_usePage.PageProvider, {
      value: props
    }, _react["default"].createElement(Renderer, props));
  };

  exports["default"] = _default;
  //# sourceMappingURL=index.js.map
});
//# sourceMappingURL=index.js.map