/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import defaultReducer from './defaultReducer.es';
import fieldReducer from './fieldReducer.es';
import pageReducer from './pageReducer.es';

const reducers = [defaultReducer, fieldReducer, pageReducer];

let hasSentEvent = false;

export const createReducer = (onEvent) => {
	return (state, action) =>
		reducers.reduce((prevState, reducer, index) => {
			const nextProperties = reducer(prevState, action);

			if (prevState === nextProperties) {

				// We only propagate the event when no event has been handled
				// before and we are at the last interaction of the reducers,
				// this ensures that we do not send unnecessary events.

				if (index === reducers.length - 1 && !hasSentEvent) {
					hasSentEvent = true;
					onEvent(action.type, action.payload);
				}

				return nextProperties;
			}

			// The reducer propagates the events so that they can be
			// handled by other components in the upper layer that are
			// not the responsibility of the form renderer, some
			// operations are transformed and treated here, we issue
			// the final result to avoid double operations that are
			// costly.

			hasSentEvent = false;
			onEvent(action.type, {
				transformation: nextProperties,
				...(typeof action.payload === 'object'
					? action.payload
					: {value: action.payload}),
			});

			return {
				...prevState,
				...nextProperties,
			};
		}, state);
};
