/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

const localDataStorage = {
	components: new Map(),
};

/**
 * Simple implementation to create a local storage that can be shared
 * independently of the React tree, Form Renderer is not an application
 * and can be reused more than once on the same page, so we need to share
 * requests and fields, they are loaded on demand, so as not to make
 * unnecessary requests. Use the `useStorage` hook as a way to cache data.
 */
export const useStorage = () => {
	return localDataStorage;
};
