/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import ClayButton from '@clayui/button';
import classnames from 'classnames';
import React from 'react';

import {MultiStep} from '../MultiStep.es';
import {PaginationControls} from '../PaginationControls.es';

/* eslint-disable react/jsx-fragments */
export const Container = ({
	activePage,
	children,
	editable,
	pageIndex,
	pages,
	readOnly,
	showSubmitButton,
	strings = null,
	submitLabel,
}) => (
	<div className="ddm-form-page-container wizard">
		{pages.length > 1 && pageIndex === activePage && (
			<MultiStep
				activePage={activePage}
				editable={editable}
				pages={pages}
			/>
		)}

		<div
			className={classnames(
				'ddm-layout-builder ddm-page-container-layout',
				{
					hide: activePage !== pageIndex,
				}
			)}
		>
			<div className="form-builder-layout">{children}</div>
		</div>

		{pageIndex === activePage && (
			<React.Fragment>
				{pages.length > 0 && (
					<PaginationControls
						activePage={activePage}
						readOnly={readOnly}
						showSubmitButton={showSubmitButton}
						strings={strings}
						submitLabel={submitLabel}
						total={pages.length}
					/>
				)}

				{!pages.length && showSubmitButton && (
					<ClayButton
						className="float-right lfr-ddm-form-submit"
						type="submit"
					>
						{submitLabel}
					</ClayButton>
				)}
			</React.Fragment>
		)}
	</div>
);
