/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import ClayButton from '@clayui/button';
import React from 'react';

import {Pagination} from '../Pagination.es';
import {PaginationControls} from '../PaginationControls.es';
import * as DefaultVariant from './DefaultVariant.es';

/* eslint-disable react/jsx-fragments */
export const Container = ({
	activePage,
	children,
	pageIndex,
	pages,
	readOnly,
	showSubmitButton,
	strings,
	submitLabel,
}) => (
	<div className="ddm-form-page-container paginated">
		<DefaultVariant.Container activePage={activePage} pageIndex={pageIndex}>
			{children}
		</DefaultVariant.Container>

		{pageIndex === activePage && (
			<React.Fragment>
				{pages.length > 0 && (
					<React.Fragment>
						<Pagination activePage={activePage} pages={pages} />
						<PaginationControls
							activePage={activePage}
							readOnly={readOnly}
							showSubmitButton={showSubmitButton}
							strings={strings}
							submitLabel={submitLabel}
							total={pages.length}
						/>
					</React.Fragment>
				)}

				{!pages.length && showSubmitButton && (
					<ClayButton
						className="float-right lfr-ddm-form-submit"
						type="submit"
					>
						{submitLabel}
					</ClayButton>
				)}
			</React.Fragment>
		)}
	</div>
);
