Liferay.Loader.define("dynamic-data-mapping-form-renderer@4.0.53/js/util/visitors.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.RulesVisitor = exports.PagesVisitor = void 0;

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var identity = function identity(value) {
    return value;
  };

  var PagesVisitor = /*#__PURE__*/function () {
    function PagesVisitor(pages) {
      _classCallCheck(this, PagesVisitor);

      this.setPages(pages);
    }

    _createClass(PagesVisitor, [{
      key: "dispose",
      value: function dispose() {
        this._pages = null;
      }
    }, {
      key: "findField",
      value: function findField(condition) {
        var conditionField;

        this._map(identity, identity, identity, function (fields) {
          for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          var field = fields.find(function (field, fieldIndex) {
            condition.apply(void 0, [field, fieldIndex].concat(args));
            return condition.apply(void 0, [field, fieldIndex].concat(args));
          });

          if (field) {
            conditionField = field;
          }
        });

        return conditionField;
      }
    }, {
      key: "mapColumns",
      value: function mapColumns(mapper) {
        return this._map(identity, identity, mapper, identity);
      }
    }, {
      key: "mapFields",
      value: function mapFields(mapper) {
        var merge = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        return this._map(identity, identity, identity, function (fields) {
          for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
            args[_key2 - 1] = arguments[_key2];
          }

          return fields.map(function (field, fieldIndex) {
            if (merge) {
              return _objectSpread({}, field, {}, mapper.apply(void 0, [field, fieldIndex].concat(args)));
            }

            return mapper.apply(void 0, [field, fieldIndex].concat(args));
          });
        });
      }
    }, {
      key: "mapPages",
      value: function mapPages(mapper) {
        return this._map(mapper, identity, identity, identity);
      }
    }, {
      key: "mapRows",
      value: function mapRows(mapper) {
        return this._map(identity, mapper, identity, identity);
      }
    }, {
      key: "setPages",
      value: function setPages(pages) {
        this._pages = _toConsumableArray(pages);
      }
    }, {
      key: "_map",
      value: function _map(pageMapper, rowMapper, columnMapper, fieldFn) {
        return this._pages.map(function (page, pageIndex) {
          var newPage = _objectSpread({}, page, {}, pageMapper(page, pageIndex));

          return _objectSpread({}, newPage, {
            rows: newPage.rows.map(function (row, rowIndex) {
              var newRow = _objectSpread({}, row, {}, rowMapper(row, rowIndex, pageIndex));

              return _objectSpread({}, newRow, {
                columns: newRow.columns.map(function (column, columnIndex) {
                  var newColumn = _objectSpread({}, column, {}, columnMapper(column, columnIndex, rowIndex, pageIndex));

                  return _objectSpread({}, newColumn, {
                    fields: fieldFn(newColumn.fields, columnIndex, rowIndex, pageIndex)
                  });
                })
              });
            })
          });
        });
      }
    }]);

    return PagesVisitor;
  }();

  exports.PagesVisitor = PagesVisitor;

  var RulesVisitor = /*#__PURE__*/function () {
    function RulesVisitor(rules) {
      _classCallCheck(this, RulesVisitor);

      this.setRules(rules);
    }

    _createClass(RulesVisitor, [{
      key: "containsField",
      value: function containsField(fieldName) {
        return this._rules.some(function (rule) {
          var actionsResult = rule.actions.some(function (_ref) {
            var target = _ref.target;
            return target === fieldName;
          });
          var conditionsResult = rule.conditions.some(function (condition) {
            return condition.operands.some(function (_ref2) {
              var type = _ref2.type,
                  value = _ref2.value;
              return type === 'field' && value === fieldName;
            });
          });
          return actionsResult || conditionsResult;
        });
      }
    }, {
      key: "containsFieldExpression",
      value: function containsFieldExpression(fieldName) {
        return this._rules.some(function (rule) {
          return rule.actions.some(function (_ref3) {
            var action = _ref3.action,
                expression = _ref3.expression;
            return action === 'calculate' && expression.includes(fieldName);
          });
        });
      }
    }, {
      key: "dispose",
      value: function dispose() {
        this._rules = null;
      }
    }, {
      key: "mapActions",
      value: function mapActions(actionMapper) {
        return this._rules.map(function (rule) {
          return _objectSpread({}, rule, {
            actions: rule.actions.map(actionMapper)
          });
        });
      }
    }, {
      key: "mapConditions",
      value: function mapConditions(conditionMapper) {
        return this._rules.map(function (rule) {
          return _objectSpread({}, rule, {
            conditions: rule.conditions.map(conditionMapper)
          });
        });
      }
    }, {
      key: "setRules",
      value: function setRules(rules) {
        this._rules = _toConsumableArray(rules);
      }
    }]);

    return RulesVisitor;
  }();

  exports.RulesVisitor = RulesVisitor;
  //# sourceMappingURL=visitors.es.js.map
});
//# sourceMappingURL=visitors.es.js.map