/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from '../../util/visitors.es';

const getEditedField = (field, editingLanguageId, name, value) => {
	return {
		...field,
		localizedValue: {
			...field.localizedValue,
			[editingLanguageId]: value
		},
		value
	};
};

const getEditedPages = (pages, editingLanguageId, name, value) => {
	const pageVisitor = new PagesVisitor(pages);

	return pageVisitor.mapFields(field => {
		if (field.name === name) {
			field = getEditedField(field, editingLanguageId, name, value);
		}
		else if (field.nestedFields) {
			field = {
				...field,
				nestedFields: field.nestedFields.map(nestedField => {
					if (nestedField.name === name) {
						nestedField = getEditedField(
							nestedField,
							editingLanguageId,
							name,
							value
						);
					}

					return nestedField;
				})
			};
		}

		return field;
	});
};

export default (evaluatorContext, properties) => {
	const {fieldInstance, value} = properties;
	const {editingLanguageId, pages} = evaluatorContext;

	return getEditedPages(pages, editingLanguageId, fieldInstance.name, value);
};
