Liferay.Loader.define("dynamic-data-mapping-form-renderer@4.0.33/js/util/fetch.es", ['module', 'exports', 'require', 'frontend-js-web'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.convertToFormData = exports.makeFetch = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  var defaultHeaders = {
    Accept: 'application/json'
  };

  var makeFetch = function makeFetch(_ref) {
    var body = _ref.body,
        _ref$headers = _ref.headers,
        headers = _ref$headers === void 0 ? defaultHeaders : _ref$headers,
        _ref$method = _ref.method,
        method = _ref$method === void 0 ? 'POST' : _ref$method,
        url = _ref.url,
        otherProps = _objectWithoutProperties(_ref, ["body", "headers", "method", "url"]);

    var fetchData = _objectSpread({
      headers: headers,
      method: method
    }, otherProps);

    if (method === 'POST') {
      fetchData.body = body;
    }

    return (0, _frontendJsWeb.fetch)(url, fetchData).then(function (response) {
      return response.json();
    })["catch"](function (error) {
      var sessionStatus = Liferay.Session.get('sessionState');

      if (sessionStatus === 'expired' || error.status === 401) {
        window.location.reload();
      } else {
        throw error;
      }
    });
  };

  exports.makeFetch = makeFetch;

  var convertToFormData = function convertToFormData(body) {
    var requestBody = body;

    if (body instanceof FormData) {
      requestBody = body;
    } else if (body instanceof HTMLFormElement) {
      requestBody = new FormData(body);
    } else if (_typeof(body) === 'object') {
      requestBody = (0, _frontendJsWeb.objectToFormData)(body);
    } else {
      requestBody = body;
    }

    return requestBody;
  };

  exports.convertToFormData = convertToFormData;
  //# sourceMappingURL=fetch.es.js.map
});
//# sourceMappingURL=fetch.es.js.map