/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DDMFormPagesTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DDMFormTemplateContextFactoryHelper;
import com.liferay.dynamic.data.mapping.form.renderer.internal.util.DDMFormTemplateContextFactoryUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.soy.util.SoyHTMLSanitizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormTemplateContextFactory.class})
public class DDMFormTemplateContextFactoryImpl
implements DDMFormTemplateContextFactory {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMDataProviderInstanceService _ddmDataProviderInstanceService;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.DDMFormContextProviderServlet)")
    private Servlet _ddmFormContextProviderServlet;
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final DDMFormTemplateContextFactoryHelper _ddmFormTemplateContextFactoryHelper = new DDMFormTemplateContextFactoryHelper();
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference
    private SoyHTMLSanitizer _soyHTMLSanitizer;

    public Map<String, Object> create(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        return this.doCreate(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    public Map<String, Object> create(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        return this.doCreate(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
    }

    protected void collectResourceBundles(Class<?> clazz, List<ResourceBundle> resourceBundles, Locale locale) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            this.collectResourceBundles(interfaceClass, resourceBundles, locale);
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, (ClassLoader)clazz.getClassLoader());
        if (resourceBundle != null) {
            resourceBundles.add(resourceBundle);
        }
    }

    protected Map<String, Object> doCreate(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        HashMap<String, Object> templateContext = new HashMap<String, Object>();
        String containerId = ddmFormRenderingContext.getContainerId();
        if (Validator.isNull((String)containerId)) {
            containerId = StringUtil.randomId();
        }
        templateContext.put("containerId", containerId);
        String currentPage = ParamUtil.getString((HttpServletRequest)ddmFormRenderingContext.getHttpServletRequest(), (String)"currentPage", (String)"1");
        templateContext.put("currentPage", currentPage);
        this.setDDMFormFieldsEvaluableProperty(ddmForm);
        templateContext.put("evaluatorURL", this.getDDMFormContextProviderServletURL());
        templateContext.put("groupId", ddmFormRenderingContext.getGroupId());
        List<Object> pages = this.getPages(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        templateContext.put("pages", pages);
        templateContext.put("portletNamespace", ddmFormRenderingContext.getPortletNamespace());
        templateContext.put("readOnly", ddmFormRenderingContext.isReadOnly());
        Locale locale = ddmFormRenderingContext.getLocale();
        if (locale == null) {
            locale = LocaleThreadLocal.getSiteDefaultLocale();
        }
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        templateContext.put("requiredFieldsWarningMessageHTML", this._soyHTMLSanitizer.sanitize(this.getRequiredFieldsWarningMessageHTML(resourceBundle, ddmFormRenderingContext.getHttpServletRequest())));
        templateContext.put("rules", this.toObjectList(ddmForm.getDDMFormRules()));
        templateContext.put("showRequiredFieldsWarning", ddmFormRenderingContext.isShowRequiredFieldsWarning());
        boolean showSubmitButton = ddmFormRenderingContext.isShowSubmitButton();
        if (ddmFormRenderingContext.isReadOnly()) {
            showSubmitButton = false;
        }
        templateContext.put("showSubmitButton", showSubmitButton);
        templateContext.put("strings", this.getLanguageStringsMap(resourceBundle));
        String submitLabel = GetterUtil.getString((String)ddmFormRenderingContext.getSubmitLabel(), (String)LanguageUtil.get((ResourceBundle)resourceBundle, (String)"submit-form"));
        templateContext.put("submitLabel", submitLabel);
        templateContext.put("templateNamespace", this.getTemplateNamespace(ddmFormLayout));
        templateContext.put("viewMode", ddmFormRenderingContext.isViewMode());
        return templateContext;
    }

    protected String getDDMFormContextProviderServletURL() {
        String servletContextPath = this.getServletContextPath();
        return servletContextPath.concat("/dynamic-data-mapping-form-context-provider/");
    }

    protected Map<String, String> getLanguageStringsMap(ResourceBundle resourceBundle) {
        HashMap<String, String> stringsMap = new HashMap<String, String>();
        stringsMap.put("next", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"next"));
        stringsMap.put("previous", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"previous"));
        return stringsMap;
    }

    protected List<Object> getPages(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) {
        DDMFormPagesTemplateContextFactory ddmFormPagesTemplateContextFactory = new DDMFormPagesTemplateContextFactory(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        ddmFormPagesTemplateContextFactory.setDDMFormEvaluator(this._ddmFormEvaluator);
        ddmFormPagesTemplateContextFactory.setDDMFormFieldTypeServicesTracker(this._ddmFormFieldTypeServicesTracker);
        return ddmFormPagesTemplateContextFactory.create();
    }

    protected String getRequiredFieldsWarningMessageHTML(ResourceBundle resourceBundle, HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler(3);
        sb.append("<label class=\"required-warning\">");
        sb.append(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"all-fields-marked-with-x-are-required", (Object)this.getRequiredMarkTagHTML(httpServletRequest), (boolean)false));
        sb.append("</label>");
        return sb.toString();
    }

    protected String getRequiredMarkTagHTML(HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler(4);
        sb.append("<svg aria-hidden=\"true\" class=\"lexicon-icon ");
        sb.append("lexicon-icon-asterisk reference-mark\"><use xlink:href=\"");
        sb.append(DDMFormTemplateContextFactoryUtil.getPathThemeImages(httpServletRequest));
        sb.append("/lexicon/icons.svg#asterisk\" /></svg>");
        return sb.toString();
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        ResourceBundle portalResourceBundle = this._portal.getResourceBundle(locale);
        resourceBundles.add(portalResourceBundle);
        this.collectResourceBundles(this.getClass(), resourceBundles, locale);
        ResourceBundle[] resourceBundlesArray = resourceBundles.toArray(new ResourceBundle[resourceBundles.size()]);
        return new AggregateResourceBundle(resourceBundlesArray);
    }

    protected String getServletContextPath() {
        String proxyPath = this._portal.getPathProxy();
        ServletConfig servletConfig = this._ddmFormContextProviderServlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        return proxyPath.concat(servletContext.getContextPath());
    }

    protected String getTemplateNamespace(DDMFormLayout ddmFormLayout) {
        String paginationMode = ddmFormLayout.getPaginationMode();
        if (Objects.equals(paginationMode, "settings")) {
            return "ddm.settings_form";
        }
        if (Objects.equals(paginationMode, "single-page")) {
            return "ddm.simple_form";
        }
        if (Objects.equals(paginationMode, "tabbed")) {
            return "ddm.tabbed_form";
        }
        if (Objects.equals(paginationMode, "wizard")) {
            return "ddm.wizard_form";
        }
        return "ddm.paginated_form";
    }

    protected void setDDMFormFieldsEvaluableProperty(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (String evaluableDDMFormFieldName : this._ddmFormTemplateContextFactoryHelper.getEvaluableDDMFormFieldNames(ddmForm)) {
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get(evaluableDDMFormFieldName);
            ddmFormField.setProperty("evaluable", (Object)true);
        }
    }

    protected Map<String, Object> toMap(DDMFormRule ddmFormRule) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actions", ddmFormRule.getActions());
        map.put("condition", ddmFormRule.getCondition());
        map.put("enable", ddmFormRule.isEnabled());
        return map;
    }

    protected List<Object> toObjectList(List<DDMFormRule> ddmFormRules) {
        if (ddmFormRules == null) {
            return Collections.emptyList();
        }
        Stream stream = ddmFormRules.stream();
        return stream.map(this::toMap).collect(Collectors.toList());
    }
}

