/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DDMFormTemplateContextFactoryHelper {
    public Set<String> getEvaluableDDMFormFieldNames(DDMForm ddmForm) {
        HashSet<String> evaluableDDMFormFieldNames = new HashSet<String>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Set<String> ddmFormFieldNames = ddmFormFieldsMap.keySet();
        evaluableDDMFormFieldNames.addAll(this.getReferencedFieldNamesByDDMFormRules(ddmForm.getDDMFormRules(), ddmFormFieldNames));
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            if (this.isDDMFormFieldEvaluable(ddmFormField)) {
                evaluableDDMFormFieldNames.add(ddmFormField.getName());
            }
            String visibilityExpression = ddmFormField.getVisibilityExpression();
            evaluableDDMFormFieldNames.addAll(this.getReferencedFieldNamesByExpression(visibilityExpression, ddmFormFieldNames));
        }
        return evaluableDDMFormFieldNames;
    }

    protected Set<String> getReferencedFieldNamesByDDMFormRules(List<DDMFormRule> ddmFormRules, Set<String> ddmFormFieldNames) {
        HashSet<String> referencedFieldNames = new HashSet<String>();
        for (DDMFormRule ddmFormRule : ddmFormRules) {
            String condition = ddmFormRule.getCondition();
            referencedFieldNames.addAll(this.getReferencedFieldNamesByExpression(condition, ddmFormFieldNames));
            for (String action : ddmFormRule.getActions()) {
                referencedFieldNames.addAll(this.getReferencedFieldNamesByExpression(action, ddmFormFieldNames));
            }
        }
        return referencedFieldNames;
    }

    protected Set<String> getReferencedFieldNamesByExpression(String expression, Set<String> ddmFormFieldNames) {
        if (Validator.isNull((String)expression)) {
            return Collections.emptySet();
        }
        HashSet<String> referencedFieldNames = new HashSet<String>();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            if (!expression.contains(ddmFormFieldName)) continue;
            referencedFieldNames.add(ddmFormFieldName);
        }
        return referencedFieldNames;
    }

    protected boolean isDDMFormFieldEvaluable(DDMFormField ddmFormField) {
        if (ddmFormField.isRequired()) {
            return true;
        }
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        return ddmFormFieldValidation != null && Validator.isNotNull((String)ddmFormFieldValidation.getExpression());
    }
}

