/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DDMFormLayoutTransformer;
import com.liferay.dynamic.data.mapping.form.renderer.internal.DDMFormRendererHelper;
import com.liferay.dynamic.data.mapping.io.DDMFormFieldTypesJSONSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutJSONSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormTemplateContextFactoryImpl
implements DDMFormTemplateContextFactory {
    @Reference
    private DDM _ddm;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.data.provider.internal.servlet.DDMDataProviderServlet)", unbind="-")
    private Servlet _ddmDataProviderServlet;
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.evaluator.internal.servlet.DDMFormEvaluatorServlet)", unbind="-")
    private Servlet _ddmFormEvaluatorServlet;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormFieldTypesJSONSerializer _ddmFormFieldTypesJSONSerializer;
    @Reference
    private DDMFormJSONSerializer _ddmFormJSONSerializer;
    @Reference
    private DDMFormLayoutJSONSerializer _ddmFormLayoutJSONSerializer;
    @Reference
    private DDMFormValuesJSONSerializer _ddmFormValuesJSONSerializer;
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public Map<String, Object> create(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        return this.doCreate(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    @Override
    public Map<String, Object> create(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        return this.doCreate(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
    }

    protected void collectResourceBundles(Class<?> clazz, List<ResourceBundle> resourceBundles, Locale locale) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            this.collectResourceBundles(interfaceClass, resourceBundles, locale);
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, (ClassLoader)clazz.getClassLoader());
        if (resourceBundle != null) {
            resourceBundles.add(resourceBundle);
        }
    }

    protected Map<String, Object> doCreate(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws PortalException {
        HashMap<String, Object> templateContext = new HashMap<String, Object>();
        String containerId = ddmFormRenderingContext.getContainerId();
        if (Validator.isNull((String)containerId)) {
            containerId = StringUtil.randomId();
        }
        templateContext.put("containerId", containerId);
        templateContext.put("dataProviderURL", this.getDDMDataProviderServletURL());
        templateContext.put("definition", this._ddmFormJSONSerializer.serialize(ddmForm));
        DDMFormValues ddmFormValues = ddmFormRenderingContext.getDDMFormValues();
        if (ddmFormValues != null) {
            this.removeStaleDDMFormFieldValues(ddmForm.getDDMFormFieldsMap(true), ddmFormValues.getDDMFormFieldValues());
        }
        Locale locale = ddmFormRenderingContext.getLocale();
        DDMFormEvaluationResult ddmFormEvaluationResult = this._ddmFormEvaluator.evaluate(ddmForm, ddmFormRenderingContext.getDDMFormValues(), locale);
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        templateContext.put("evaluation", jsonSerializer.serializeDeep((Object)ddmFormEvaluationResult));
        templateContext.put("evaluatorURL", this.getDDMFormEvaluatorServletURL());
        List ddmFormFieldTypes = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypes();
        templateContext.put("fieldTypes", this._ddmFormFieldTypesJSONSerializer.serialize(ddmFormFieldTypes));
        templateContext.put("layout", this._ddmFormLayoutJSONSerializer.serialize(ddmFormLayout));
        List<Object> pages = this.getPages(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        templateContext.put("pages", pages);
        templateContext.put("portletNamespace", ddmFormRenderingContext.getPortletNamespace());
        templateContext.put("readOnly", ddmFormRenderingContext.isReadOnly());
        JSONArray readOnlyFieldsJSONArray = this.getReadOnlyFieldsJSONArray(ddmForm);
        templateContext.put("readOnlyFields", readOnlyFieldsJSONArray.toString());
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        templateContext.put("requiredFieldsWarningMessageHTML", this.getRequiredFieldsWarningMessageHTML(resourceBundle));
        templateContext.put("showRequiredFieldsWarning", ddmFormRenderingContext.isShowRequiredFieldsWarning());
        boolean showSubmitButton = ddmFormRenderingContext.isShowSubmitButton();
        if (ddmFormRenderingContext.isReadOnly()) {
            showSubmitButton = false;
        }
        templateContext.put("showSubmitButton", showSubmitButton);
        templateContext.put("strings", this.getLanguageStringsMap(resourceBundle));
        String submitLabel = GetterUtil.getString((String)ddmFormRenderingContext.getSubmitLabel(), (String)LanguageUtil.get((Locale)locale, (String)"submit"));
        templateContext.put("submitLabel", submitLabel);
        templateContext.put("templateNamespace", this.getTemplateNamespace(ddmFormLayout));
        if (ddmFormValues != null) {
            templateContext.put("values", this._ddmFormValuesJSONSerializer.serialize(ddmFormValues));
        } else {
            templateContext.put("values", JSONFactoryUtil.getNullJSON());
        }
        return templateContext;
    }

    protected String getDDMDataProviderServletURL() {
        String servletContextPath = this.getServletContextPath(this._ddmDataProviderServlet);
        return servletContextPath.concat("/dynamic-data-mapping-data-provider/");
    }

    protected String getDDMFormEvaluatorServletURL() {
        String servletContextPath = this.getServletContextPath(this._ddmFormEvaluatorServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-evaluator/");
    }

    protected Map<String, String> getLanguageStringsMap(ResourceBundle resourceBundle) {
        HashMap<String, String> stringsMap = new HashMap<String, String>();
        stringsMap.put("next", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"next"));
        stringsMap.put("previous", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"previous"));
        return stringsMap;
    }

    protected List<Object> getPages(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        Map<String, String> renderedDDMFormFieldsMap = this.getRenderedDDMFormFieldsMap(ddmForm, ddmFormRenderingContext);
        DDMFormLayoutTransformer ddmFormLayoutTransformer = new DDMFormLayoutTransformer(ddmForm, ddmFormLayout, renderedDDMFormFieldsMap, ddmFormRenderingContext.isShowRequiredFieldsWarning(), ddmFormRenderingContext.getLocale());
        return ddmFormLayoutTransformer.getPages();
    }

    protected JSONArray getReadOnlyFieldsJSONArray(DDMForm ddmForm) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (!ddmFormField.isReadOnly()) continue;
            jsonArray.put(ddmFormField.getName());
        }
        return jsonArray;
    }

    protected Map<String, String> getRenderedDDMFormFieldsMap(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        DDMFormRendererHelper ddmFormRendererHelper = new DDMFormRendererHelper(ddmForm, ddmFormRenderingContext);
        ddmFormRendererHelper.setDDMFormFieldTypeServicesTracker(this._ddmFormFieldTypeServicesTracker);
        ddmFormRendererHelper.setDDMFormEvaluator(this._ddmFormEvaluator);
        return ddmFormRendererHelper.getRenderedDDMFormFieldsMap();
    }

    protected String getRequiredFieldsWarningMessageHTML(ResourceBundle resourceBundle) {
        StringBundler sb = new StringBundler(3);
        sb.append("<label class=\"required-warning\">");
        sb.append(LanguageUtil.format((ResourceBundle)resourceBundle, (String)"all-fields-marked-with-x-are-required", (Object)"<i class=\"icon-asterisk text-warning\"></i>", (boolean)false));
        sb.append("</label>");
        return sb.toString();
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        ResourceBundle portalResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, (ClassLoader)PortalClassLoaderUtil.getClassLoader());
        resourceBundles.add(portalResourceBundle);
        this.collectResourceBundles(this.getClass(), resourceBundles, locale);
        ResourceBundle[] resourceBundlesArray = resourceBundles.toArray(new ResourceBundle[resourceBundles.size()]);
        return new AggregateResourceBundle(resourceBundlesArray);
    }

    protected String getServletContextPath(Servlet servlet) {
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        return servletContext.getContextPath();
    }

    protected String getTemplateNamespace(DDMFormLayout ddmFormLayout) {
        String paginationMode = ddmFormLayout.getPaginationMode();
        if (Objects.equals(paginationMode, "single-page")) {
            return "ddm.simple_form";
        }
        if (Objects.equals(paginationMode, "tabbed")) {
            return "ddm.tabbed_form";
        }
        return "ddm.paginated_form";
    }

    protected void removeStaleDDMFormFieldValues(Map<String, DDMFormField> ddmFormFieldsMap, List<DDMFormFieldValue> ddmFormFieldValues) {
        Iterator<DDMFormFieldValue> iterator = ddmFormFieldValues.iterator();
        while (iterator.hasNext()) {
            DDMFormFieldValue ddmFormFieldValue = iterator.next();
            if (!ddmFormFieldsMap.containsKey(ddmFormFieldValue.getName())) {
                iterator.remove();
            }
            this.removeStaleDDMFormFieldValues(ddmFormFieldsMap, ddmFormFieldValue.getNestedDDMFormFieldValues());
        }
    }
}

