/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.taglib.helper;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.taglib.DDMFormFieldTypesDynamicInclude;
import com.liferay.dynamic.data.mapping.io.DDMFormFieldTypesJSONSerializer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.BaseDynamicInclude;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.IOException;

import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.osgi.service.component.annotations.Reference;

/**
 * @author Bruno Basto
 */
public abstract class BaseDDMFormFieldTypesDynamicInclude
	extends BaseDynamicInclude {

	protected void include(HttpServletResponse response) throws IOException {
		ScriptData scriptData = new ScriptData();

		List<DDMFormFieldType> ddmFormFieldTypes =
			ddmFormFieldTypeServicesTracker.getDDMFormFieldTypes();

		try {
			scriptData.append(
				null,
				StringUtil.replaceToStringBundler(
					_TMPL_CONTENT, StringPool.POUND, StringPool.POUND,
					Collections.singletonMap(
						"fieldTypes",
						ddmFormFieldTypesJSONSerialize.serialize(
							ddmFormFieldTypes))),
				_MODULES, ScriptData.ModulesType.AUI);
		}
		catch (PortalException pe) {
			if (_log.isDebugEnabled()) {
				_log.debug(pe, pe);
			}
		}

		scriptData.writeTo(response.getWriter());
	}

	@Reference
	protected DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker;

	@Reference
	protected DDMFormFieldTypesJSONSerializer ddmFormFieldTypesJSONSerialize;

	private static String _getTemplateContent() {
		if (Validator.isNull(_TMPL_CONTENT)) {
			try {
				return StringUtil.read(
					DDMFormFieldTypesDynamicInclude.class.getClassLoader(),
					"/META-INF/resources/dynamic_include/field_types.tmpl");
			}
			catch (IOException ioe) {
				if (_log.isDebugEnabled()) {
					_log.debug(ioe, ioe);
				}

				return StringPool.BLANK;
			}
		}

		return _TMPL_CONTENT;
	}

	private static final String _MODULES =
		"liferay-ddm-form-renderer-types,liferay-ddm-soy-template-util";

	private static final String _TMPL_CONTENT = _getTemplateContent();

	private static final Log _log = LogFactoryUtil.getLog(
		BaseDDMFormFieldTypesDynamicInclude.class);

}