/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMFormLayoutTransformer {
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final DDMFormLayout _ddmFormLayout;
    private final Locale _locale;
    private final Map<String, String> _renderedDDMFormFieldsMap;
    private final boolean _showRequiredFieldsWarning;

    public DDMFormLayoutTransformer(DDMForm ddmForm, DDMFormLayout ddmFormLayout, Map<String, String> renderedDDMFormFieldsMap, boolean showRequiredFieldsWarning, Locale locale) {
        this._ddmFormLayout = ddmFormLayout;
        this._renderedDDMFormFieldsMap = renderedDDMFormFieldsMap;
        this._showRequiredFieldsWarning = showRequiredFieldsWarning;
        this._locale = locale;
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
    }

    public List<Object> getPages() {
        return this.getPages(this._ddmFormLayout.getDDMFormLayoutPages());
    }

    protected boolean containsRequiredField(List<String> ddmFormFieldNames) {
        for (String ddmFormFieldName : ddmFormFieldNames) {
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldName);
            if (!ddmFormField.isRequired()) continue;
            return true;
        }
        return false;
    }

    protected Map<String, Object> getColumn(DDMFormLayoutColumn ddmFormLayoutColumn) {
        HashMap<String, Object> column = new HashMap<String, Object>();
        column.put("fields", this.getFields(ddmFormLayoutColumn.getDDMFormFieldNames()));
        column.put("size", ddmFormLayoutColumn.getSize());
        return column;
    }

    protected List<Object> getColumns(List<DDMFormLayoutColumn> ddmFormLayoutColumns) {
        ArrayList<Object> columns = new ArrayList<Object>();
        for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutColumns) {
            columns.add(this.getColumn(ddmFormLayoutColumn));
        }
        return columns;
    }

    protected List<String> getFields(List<String> ddmFormFieldNames) {
        ArrayList<String> renderedDDMFormFields = new ArrayList<String>();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            renderedDDMFormFields.add(this._renderedDDMFormFieldsMap.get(ddmFormFieldName));
        }
        return renderedDDMFormFields;
    }

    protected Map<String, Object> getPage(DDMFormLayoutPage ddmFormLayoutPage) {
        HashMap<String, Object> page = new HashMap<String, Object>();
        LocalizedValue description = ddmFormLayoutPage.getDescription();
        page.put("description", description.getString(this._locale));
        page.put("rows", this.getRows(ddmFormLayoutPage.getDDMFormLayoutRows()));
        boolean showRequiredFieldsWarning = this.isShowRequiredFieldsWarning(ddmFormLayoutPage.getDDMFormLayoutRows());
        page.put("showRequiredFieldsWarning", showRequiredFieldsWarning);
        LocalizedValue title = ddmFormLayoutPage.getTitle();
        page.put("title", title.getString(this._locale));
        return page;
    }

    protected List<Object> getPages(List<DDMFormLayoutPage> ddmFormLayoutPages) {
        ArrayList<Object> pages = new ArrayList<Object>();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayoutPages) {
            pages.add(this.getPage(ddmFormLayoutPage));
        }
        return pages;
    }

    protected Map<String, Object> getRow(DDMFormLayoutRow ddmFormLayoutRow) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("columns", this.getColumns(ddmFormLayoutRow.getDDMFormLayoutColumns()));
        return row;
    }

    protected List<Object> getRows(List<DDMFormLayoutRow> ddmFormLayoutRows) {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            rows.add(this.getRow(ddmFormLayoutRow));
        }
        return rows;
    }

    protected boolean isShowRequiredFieldsWarning(List<DDMFormLayoutRow> ddmFormLayoutRows) {
        if (!this._showRequiredFieldsWarning) {
            return false;
        }
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                if (!this.containsRequiredField(ddmFormLayoutColumn.getDDMFormFieldNames())) continue;
                return true;
            }
        }
        return false;
    }
}

