/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;

public class DDMFormEvaluatorHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEvaluatorHelper.class);
    private DDMExpressionFactory _ddmExpressionFactory;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private JSONFactory _jsonFactory;
    private final Locale _locale;
    private final List<DDMFormFieldValue> _rootDDMFormFieldValues;

    public DDMFormEvaluatorHelper(DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        if (ddmFormValues == null) {
            ddmFormValues = this.createEmptyDDMFormValues(ddmForm);
        }
        this._rootDDMFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        this._locale = locale;
    }

    public DDMFormEvaluationResult evaluate() throws PortalException {
        DDMFormEvaluationResult ddmFormEvaluationResult = new DDMFormEvaluationResult();
        List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = this.evaluateDDMFormFieldValues(this._rootDDMFormFieldValues, new HashSet<DDMFormFieldValue>());
        ddmFormEvaluationResult.setDDMFormFieldEvaluationResults(ddmFormFieldEvaluationResults);
        return ddmFormEvaluationResult;
    }

    protected DDMFormValues createEmptyDDMFormValues(DDMForm ddmForm) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(ddmFormField.getName());
            UnlocalizedValue value = new UnlocalizedValue("");
            if (ddmFormField.isLocalizable()) {
                value = new LocalizedValue(this._locale);
                value.addString(this._locale, "");
            }
            ddmFormFieldValue.setValue((Value)value);
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    protected boolean evaluateBooleanExpression(String expressionString, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        if (Validator.isNull((String)expressionString)) {
            return true;
        }
        DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(expressionString);
        try {
            this.setDDMExpressionVariables((DDMExpression<Boolean>)ddmExpression, this._rootDDMFormFieldValues, ancestorDDMFormFieldValues);
            return (Boolean)ddmExpression.evaluate();
        }
        catch (DDMExpressionException ddmee) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid expression or expression that is making reference to a field no longer available: " + expressionString));
            }
            return true;
        }
    }

    protected DDMFormFieldEvaluationResult evaluateDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        ancestorDDMFormFieldValues.add(ddmFormFieldValue);
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = this.evaluateDDMFormFieldValue(ddmFormFieldValue, ancestorDDMFormFieldValues, ddmFormField);
        ancestorDDMFormFieldValues.remove(ddmFormFieldValue);
        return ddmFormFieldEvaluationResult;
    }

    protected DDMFormFieldEvaluationResult evaluateDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Set<DDMFormFieldValue> ancestorDDMFormFieldValues, DDMFormField ddmFormField) throws PortalException {
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = new DDMFormFieldEvaluationResult(ddmFormFieldValue.getName(), ddmFormFieldValue.getInstanceId());
        boolean visible = this.evaluateBooleanExpression(ddmFormField.getVisibilityExpression(), ancestorDDMFormFieldValues);
        ddmFormFieldEvaluationResult.setVisible(visible);
        if (visible && ddmFormField.isRequired() && this.isDDMFormFieldValueEmpty(ddmFormFieldValue)) {
            ddmFormFieldEvaluationResult.setErrorMessage(LanguageUtil.get((Locale)this._locale, (String)"this-field-is-required"));
            ddmFormFieldEvaluationResult.setValid(false);
        } else if (!this.isDDMFormFieldValueEmpty(ddmFormFieldValue)) {
            DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
            String validationExpression = this.getValidationExpression(ddmFormFieldValidation);
            try {
                boolean valid = this.evaluateBooleanExpression(validationExpression, ancestorDDMFormFieldValues);
                ddmFormFieldEvaluationResult.setValid(valid);
                if (!valid) {
                    ddmFormFieldEvaluationResult.setErrorMessage(ddmFormFieldValidation.getErrorMessage());
                }
            }
            catch (NumberFormatException nfe) {
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this._locale, this.getClass());
                ddmFormFieldEvaluationResult.setErrorMessage(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"the-text-is-not-a-number-or-exceeds-the-maximum-value"));
                ddmFormFieldEvaluationResult.setValid(false);
            }
        }
        List<DDMFormFieldEvaluationResult> nestedDDMFormFieldEvaluationResults = this.evaluateDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ancestorDDMFormFieldValues);
        ddmFormFieldEvaluationResult.setNestedDDMFormFieldEvaluationResults(nestedDDMFormFieldEvaluationResults);
        return ddmFormFieldEvaluationResult;
    }

    protected List<DDMFormFieldEvaluationResult> evaluateDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        ArrayList<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = new ArrayList<DDMFormFieldEvaluationResult>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = this.evaluateDDMFormFieldValue(ddmFormFieldValue, ancestorDDMFormFieldValues);
            ddmFormFieldEvaluationResults.add(ddmFormFieldEvaluationResult);
        }
        return ddmFormFieldEvaluationResults;
    }

    protected String getJSONArrayValueString(String valueString) {
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
            return jsonArray.getString(0);
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsone, (Throwable)jsone);
            }
            return valueString;
        }
    }

    protected String getValidationExpression(DDMFormFieldValidation ddmFormFieldValidation) {
        if (ddmFormFieldValidation == null) {
            return null;
        }
        return ddmFormFieldValidation.getExpression();
    }

    protected String getValueString(Value value, String type) {
        if (value == null) {
            return null;
        }
        String valueString = value.getString(this._locale);
        if (type.equals("select") || type.equals("radio")) {
            valueString = this.getJSONArrayValueString(valueString);
        }
        return valueString;
    }

    protected String getVariableType(String dataType, String valueString) {
        if (dataType.equals("integer") && !Validator.isNumber((String)valueString)) {
            return "double";
        }
        return dataType;
    }

    protected boolean isDDMFormFieldValueEmpty(DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return true;
        }
        String valueString = GetterUtil.getString((String)value.getString(this._locale));
        if (valueString.isEmpty()) {
            return true;
        }
        DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
        String dataType = ddmFormField.getDataType();
        return Objects.equals(dataType, "boolean") && Objects.equals(valueString, "false");
    }

    protected void setDDMExpressionFactory(DDMExpressionFactory ddmExpressionFactory) {
        this._ddmExpressionFactory = ddmExpressionFactory;
    }

    protected void setDDMExpressionVariables(DDMExpression<Boolean> ddmExpression, List<DDMFormFieldValue> ddmFormFieldValues, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            String name = ddmFormFieldValue.getName();
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(name);
            if (ddmFormField.isRepeatable() && !ancestorDDMFormFieldValues.contains(ddmFormFieldValue)) continue;
            String valueString = this.getValueString(ddmFormFieldValue.getValue(), ddmFormField.getType());
            if (valueString != null) {
                this.setExpressionVariableValue(ddmExpression, name, this.getVariableType(ddmFormField.getDataType(), valueString), valueString);
            }
            this.setDDMExpressionVariables(ddmExpression, ddmFormFieldValue.getNestedDDMFormFieldValues(), ancestorDDMFormFieldValues);
        }
    }

    protected void setExpressionVariableValue(DDMExpression<Boolean> ddmExpression, String variableName, String variableType, String variableValue) throws PortalException {
        if (variableType.equals("boolean")) {
            ddmExpression.setBooleanVariableValue(variableName, Boolean.valueOf(GetterUtil.getBoolean((String)variableValue)));
        } else if (variableType.equals("double")) {
            ddmExpression.setDoubleVariableValue(variableName, Double.valueOf(Double.parseDouble(variableValue)));
        } else if (variableType.equals("integer")) {
            ddmExpression.setLongVariableValue(variableName, Long.valueOf(GetterUtil.getLongStrict((String)variableValue)));
        } else if (variableType.equals("string")) {
            ddmExpression.setStringVariableValue(variableName, variableValue);
        }
    }

    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }
}

