/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.servlet;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-evaluator", "osgi.http.whiteboard.servlet.name=Dynamic Data Mapping Form Evaluator Servlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-evaluator/*"}, service={Servlet.class})
public class DDMFormEvaluatorServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEvaluatorServlet.class);
    private static final long serialVersionUID = 1L;
    private DDMFormEvaluator _ddmFormEvaluator;
    private DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private JSONFactory _jsonFactory;

    protected DDMFormEvaluationResult doEvaluate(String serializedDDMForm, String serializedDDMFormValues, String languageId) {
        try {
            DDMForm ddmForm = this._ddmFormJSONDeserializer.deserialize(serializedDDMForm);
            DDMFormValues ddmFormValues = this._ddmFormValuesJSONDeserializer.deserialize(ddmForm, serializedDDMFormValues);
            return this._ddmFormEvaluator.evaluate(ddmForm, ddmFormValues, LocaleUtil.fromLanguageId((String)languageId));
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String languageId;
        String serializedDDMFormValues;
        String serializedDDMForm = ParamUtil.getString((HttpServletRequest)request, (String)"serializedDDMForm");
        DDMFormEvaluationResult ddmFormEvaluationResult = this.doEvaluate(serializedDDMForm, serializedDDMFormValues = ParamUtil.getString((HttpServletRequest)request, (String)"serializedDDMFormValues"), languageId = ParamUtil.getString((HttpServletRequest)request, (String)"languageId"));
        if (ddmFormEvaluationResult == null) {
            response.sendError(400);
            return;
        }
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        response.setContentType("application/json");
        response.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)response, (String)jsonSerializer.serializeDeep((Object)ddmFormEvaluationResult));
    }

    @Reference(unbind="-")
    protected void setDDMFormEvaluator(DDMFormEvaluator ddmFormEvaluator) {
        this._ddmFormEvaluator = ddmFormEvaluator;
    }

    @Reference(unbind="-")
    protected void setDDMFormJSONDeserializer(DDMFormJSONDeserializer ddmFormJSONDeserializer) {
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }
}

