/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMFormEvaluatorHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormEvaluatorHelper.class);
    private DDMExpressionFactory _ddmExpressionFactory;
    private final Map<String, DDMFormField> _ddmFormFieldsMap;
    private final Locale _locale;
    private final List<DDMFormFieldValue> _rootDDMFormFieldValues;

    public DDMFormEvaluatorHelper(DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        this._ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        if (ddmFormValues == null) {
            ddmFormValues = this.createEmptyDDMFormValues(ddmForm);
        }
        this._rootDDMFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        this._locale = locale;
    }

    public DDMFormEvaluationResult evaluate() throws PortalException {
        DDMFormEvaluationResult ddmFormEvaluationResult = new DDMFormEvaluationResult();
        List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = this.evaluateDDMFormFieldValues(this._rootDDMFormFieldValues, new HashSet<DDMFormFieldValue>());
        ddmFormEvaluationResult.setDDMFormFieldEvaluationResults(ddmFormFieldEvaluationResults);
        return ddmFormEvaluationResult;
    }

    protected DDMFormValues createEmptyDDMFormValues(DDMForm ddmForm) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(ddmFormField.getName());
            UnlocalizedValue value = new UnlocalizedValue("");
            if (ddmFormField.isLocalizable()) {
                value = new LocalizedValue(this._locale);
                value.addString(this._locale, "");
            }
            ddmFormFieldValue.setValue((Value)value);
            ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
        }
        return ddmFormValues;
    }

    protected boolean evaluateBooleanExpression(String expressionString, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        if (Validator.isNull((String)expressionString)) {
            return true;
        }
        DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(expressionString);
        this.setDDMExpressionVariables((DDMExpression<Boolean>)ddmExpression, this._rootDDMFormFieldValues, ancestorDDMFormFieldValues);
        try {
            return (Boolean)ddmExpression.evaluate();
        }
        catch (DDMExpressionException ddmee) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid expression or expression that is making reference to a field no longer available: " + expressionString));
            }
            return true;
        }
    }

    protected DDMFormFieldEvaluationResult evaluateDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        ancestorDDMFormFieldValues.add(ddmFormFieldValue);
        DDMFormField ddmFormField = this._ddmFormFieldsMap.get(ddmFormFieldValue.getName());
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = this.evaluateDDMFormFieldValue(ddmFormFieldValue, ancestorDDMFormFieldValues, ddmFormField);
        ancestorDDMFormFieldValues.remove(ddmFormFieldValue);
        return ddmFormFieldEvaluationResult;
    }

    protected DDMFormFieldEvaluationResult evaluateDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, Set<DDMFormFieldValue> ancestorDDMFormFieldValues, DDMFormField ddmFormField) throws PortalException {
        DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = new DDMFormFieldEvaluationResult(ddmFormFieldValue.getName(), ddmFormFieldValue.getInstanceId());
        if (ddmFormField.isRequired() && this.isDDMFormFieldValueEmpty(ddmFormFieldValue)) {
            ddmFormFieldEvaluationResult.setErrorMessage(LanguageUtil.get((Locale)this._locale, (String)"this-field-is-required"));
            ddmFormFieldEvaluationResult.setValid(false);
        } else if (!this.isDDMFormFieldValueEmpty(ddmFormFieldValue)) {
            DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
            String validationExpression = this.getValidationExpression(ddmFormFieldValidation);
            boolean valid = this.evaluateBooleanExpression(validationExpression, ancestorDDMFormFieldValues);
            ddmFormFieldEvaluationResult.setValid(valid);
            if (!valid) {
                ddmFormFieldEvaluationResult.setErrorMessage(ddmFormFieldValidation.getErrorMessage());
            }
        }
        boolean visible = this.evaluateBooleanExpression(ddmFormField.getVisibilityExpression(), ancestorDDMFormFieldValues);
        ddmFormFieldEvaluationResult.setVisible(visible);
        List<DDMFormFieldEvaluationResult> nestedDDMFormFieldEvaluationResults = this.evaluateDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ancestorDDMFormFieldValues);
        ddmFormFieldEvaluationResult.setNestedDDMFormFieldEvaluationResults(nestedDDMFormFieldEvaluationResults);
        return ddmFormFieldEvaluationResult;
    }

    protected List<DDMFormFieldEvaluationResult> evaluateDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        ArrayList<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = new ArrayList<DDMFormFieldEvaluationResult>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult = this.evaluateDDMFormFieldValue(ddmFormFieldValue, ancestorDDMFormFieldValues);
            ddmFormFieldEvaluationResults.add(ddmFormFieldEvaluationResult);
        }
        return ddmFormFieldEvaluationResults;
    }

    protected String getValidationExpression(DDMFormFieldValidation ddmFormFieldValidation) {
        if (ddmFormFieldValidation == null) {
            return null;
        }
        return ddmFormFieldValidation.getExpression();
    }

    protected String getValueString(Value value, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.getString(this._locale);
    }

    protected boolean isDDMFormFieldValueEmpty(DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return true;
        }
        String valueString = GetterUtil.getString((String)value.getString(this._locale));
        if (valueString.isEmpty()) {
            return true;
        }
        DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
        String dataType = ddmFormField.getDataType();
        return Validator.equals((Object)dataType, (Object)"boolean") && Validator.equals((Object)valueString, (Object)"false");
    }

    protected void setDDMExpressionFactory(DDMExpressionFactory ddmExpressionFactory) {
        this._ddmExpressionFactory = ddmExpressionFactory;
    }

    protected void setDDMExpressionVariables(DDMExpression<Boolean> ddmExpression, List<DDMFormFieldValue> ddmFormFieldValues, Set<DDMFormFieldValue> ancestorDDMFormFieldValues) throws PortalException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            String name = ddmFormFieldValue.getName();
            DDMFormField ddmFormField = this._ddmFormFieldsMap.get(name);
            if (ddmFormField.isRepeatable() && !ancestorDDMFormFieldValues.contains(ddmFormFieldValue)) continue;
            String valueString = this.getValueString(ddmFormFieldValue.getValue(), this._locale);
            if (valueString != null) {
                this.setExpressionVariableValue(ddmExpression, name, ddmFormField.getDataType(), valueString);
            }
            this.setDDMExpressionVariables(ddmExpression, ddmFormFieldValue.getNestedDDMFormFieldValues(), ancestorDDMFormFieldValues);
        }
    }

    protected void setExpressionVariableValue(DDMExpression<Boolean> ddmExpression, String variableName, String variableType, String variableValue) throws PortalException {
        if (variableType.equals("boolean")) {
            ddmExpression.setBooleanVariableValue(variableName, Boolean.valueOf(GetterUtil.getBoolean((String)variableValue)));
        } else if (variableType.equals("integer")) {
            ddmExpression.setIntegerVariableValue(variableName, Integer.valueOf(GetterUtil.getInteger((String)variableValue)));
        } else if (variableType.equals("string")) {
            ddmExpression.setStringVariableValue(variableName, variableValue);
        }
    }
}

