/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionRegistry;
import com.liferay.dynamic.data.mapping.form.builder.internal.servlet.BaseDDMFormBuilderServlet;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dynamic.data.mapping.form.builder.servlet=true", "osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-functions", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFormFunctionsServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-functions/*"}, service={Servlet.class})
public class DDMFormFunctionsServlet
extends BaseDDMFormBuilderServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    private DDMExpressionFunctionRegistry _ddmExpressionFunctionRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Map<String, DDMExpressionFunctionFactory> ddmExpressionFunctionFactories = this._getDDMExpressionFunctionFactories();
        JSONArray jsonArray = this._toJSONArray(ddmExpressionFunctionFactories.entrySet(), LocaleUtil.fromLanguageId((String)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId")));
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonArray.toString());
    }

    protected JSONObject toJSONObject(Map.Entry<String, DDMExpressionFunctionFactory> entry, ResourceBundle resourceBundle) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        String key = entry.getKey();
        String labelLanguageKey = key + "_function";
        jsonObject.put("label", this._language.get(resourceBundle, labelLanguageKey)).put("value", key);
        String tooltipLanguageKey = key + "_tooltip";
        jsonObject.put("tooltip", this._language.get(resourceBundle, tooltipLanguageKey));
        return jsonObject;
    }

    private Map<String, DDMExpressionFunctionFactory> _getDDMExpressionFunctionFactories() {
        HashSet<String> functionNames = new HashSet<String>();
        functionNames.add("sum");
        return this._ddmExpressionFunctionRegistry.getDDMExpressionFunctionFactories(functionNames);
    }

    private JSONArray _toJSONArray(Set<Map.Entry<String, DDMExpressionFunctionFactory>> entries, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ((Object)((Object)this)).getClass());
        for (Map.Entry<String, DDMExpressionFunctionFactory> entry : entries) {
            jsonArray.put(this.toJSONObject(entry, resourceBundle));
        }
        return jsonArray;
    }
}

