/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.context;

import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializer;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializerRequest;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"dynamic.data.mapping.form.builder.context.deserializer.type=formLayout"}, service={DDMFormContextDeserializer.class})
public class DDMFormContextToDDMFormLayout
implements DDMFormContextDeserializer<DDMFormLayout> {
    @Reference
    protected JSONFactory jsonFactory;

    public DDMFormLayout deserialize(DDMFormContextDeserializerRequest ddmFormContextDeserializerRequest) throws PortalException {
        String serializedFormContext = (String)ddmFormContextDeserializerRequest.getProperty("serializedFormContext");
        if (Validator.isNull((String)serializedFormContext)) {
            throw new IllegalStateException("The property \"serializedFormContext\" is required");
        }
        return this.deserialize(serializedFormContext);
    }

    protected DDMFormLayout deserialize(String serializedFormContext) throws PortalException {
        JSONObject jsonObject = this.jsonFactory.createJSONObject(serializedFormContext);
        DDMFormLayout ddmFormLayout = new DDMFormLayout();
        this._setDDMFormLayoutAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmFormLayout);
        this._setDDMFormLayoutDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmFormLayout);
        this._setDDMFormLayoutPages(jsonObject.getJSONArray("pages"), ddmFormLayout);
        this._setDDMFormLayoutPaginationMode(jsonObject.getString("paginationMode", "wizard"), ddmFormLayout);
        return ddmFormLayout;
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            availableLocales.add(LocaleUtil.fromLanguageId((String)jsonArray.getString(i)));
        }
        return availableLocales;
    }

    protected Locale getDefaultLocale(String defaultLanguageId) {
        return LocaleUtil.fromLanguageId((String)defaultLanguageId);
    }

    protected LocalizedValue getLocalizedValue(JSONObject jsonObject, Set<Locale> availableLocales, Locale defaultLocale) {
        LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
        String defaultValueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)defaultLocale));
        for (Locale availableLocale : availableLocales) {
            String valueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)availableLocale), defaultValueString);
            localizedValue.addString(availableLocale, valueString);
        }
        return localizedValue;
    }

    private DDMFormLayoutColumn _getDDMFormLayoutColumn(JSONObject jsonObject) {
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(jsonObject.getInt("size"), new String[0]);
        this._setDDMFormLayoutColumnFieldNames(jsonObject.getJSONArray("fields"), ddmFormLayoutColumn);
        return ddmFormLayoutColumn;
    }

    private List<DDMFormLayoutColumn> _getDDMFormLayoutColumns(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutColumn> ddmFormLayoutColumns = new ArrayList<DDMFormLayoutColumn>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmFormLayoutColumns.add(this._getDDMFormLayoutColumn(jsonArray.getJSONObject(i)));
        }
        return ddmFormLayoutColumns;
    }

    private DDMFormLayoutPage _getDDMFormLayoutPage(JSONObject jsonObject, Set<Locale> availableLocales, Locale defaultLocale) {
        DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
        this._setDDMFormLayoutPageDescription(jsonObject.getJSONObject("description"), availableLocales, defaultLocale, ddmFormLayoutPage);
        this._setDDMFormLayoutPageRows(jsonObject.getJSONArray("rows"), ddmFormLayoutPage);
        this._setDDMFormLayoutPageTitle(jsonObject.getJSONObject("title"), availableLocales, defaultLocale, ddmFormLayoutPage);
        return ddmFormLayoutPage;
    }

    private List<DDMFormLayoutPage> _getDDMFormLayoutPages(JSONArray jsonArray, Set<Locale> availableLocales, Locale defaultLocale) {
        ArrayList<DDMFormLayoutPage> ddmFormLayoutPages = new ArrayList<DDMFormLayoutPage>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmFormLayoutPages.add(this._getDDMFormLayoutPage(jsonArray.getJSONObject(i), availableLocales, defaultLocale));
        }
        return ddmFormLayoutPages;
    }

    private DDMFormLayoutRow _getDDMFormLayoutRow(JSONObject jsonObject) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        this._setDDMFormLayoutRowColumns(jsonObject.getJSONArray("columns"), ddmFormLayoutRow);
        return ddmFormLayoutRow;
    }

    private List<DDMFormLayoutRow> _getDDMFormLayoutRows(JSONArray jsonArray) {
        ArrayList<DDMFormLayoutRow> ddmFormLayoutRows = new ArrayList<DDMFormLayoutRow>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmFormLayoutRows.add(this._getDDMFormLayoutRow(jsonArray.getJSONObject(i)));
        }
        return ddmFormLayoutRows;
    }

    private void _setDDMFormLayoutAvailableLocales(JSONArray jsonArray, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setAvailableLocales(this.getAvailableLocales(jsonArray));
    }

    private void _setDDMFormLayoutColumnFieldNames(JSONArray jsonArray, DDMFormLayoutColumn ddmFormLayoutColumn) {
        ArrayList<String> ddmFormFieldNames = new ArrayList<String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ddmFormFieldNames.add(jsonObject.getString("fieldName"));
        }
        ddmFormLayoutColumn.setDDMFormFieldNames(ddmFormFieldNames);
    }

    private void _setDDMFormLayoutDefaultLocale(String defaultLanguageId, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setDefaultLocale(LocaleUtil.fromLanguageId((String)defaultLanguageId));
    }

    private void _setDDMFormLayoutPageDescription(JSONObject jsonObject, Set<Locale> availableLocales, Locale defaultLocale, DDMFormLayoutPage ddmFormLayoutPage) {
        ddmFormLayoutPage.setDescription(this.getLocalizedValue(jsonObject, availableLocales, defaultLocale));
    }

    private void _setDDMFormLayoutPageRows(JSONArray jsonArray, DDMFormLayoutPage ddmFormLayoutPage) {
        ddmFormLayoutPage.setDDMFormLayoutRows(this._getDDMFormLayoutRows(jsonArray));
    }

    private void _setDDMFormLayoutPages(JSONArray jsonArray, DDMFormLayout ddmFormLayout) {
        List<DDMFormLayoutPage> ddmFormLayoutPages = this._getDDMFormLayoutPages(jsonArray, ddmFormLayout.getAvailableLocales(), ddmFormLayout.getDefaultLocale());
        ddmFormLayout.setDDMFormLayoutPages(ddmFormLayoutPages);
    }

    private void _setDDMFormLayoutPageTitle(JSONObject jsonObject, Set<Locale> availableLocales, Locale defaultLocale, DDMFormLayoutPage ddmFormLayoutPage) {
        ddmFormLayoutPage.setTitle(this.getLocalizedValue(jsonObject, availableLocales, defaultLocale));
    }

    private void _setDDMFormLayoutPaginationMode(String paginationMode, DDMFormLayout ddmFormLayout) {
        ddmFormLayout.setPaginationMode(paginationMode);
    }

    private void _setDDMFormLayoutRowColumns(JSONArray jsonArray, DDMFormLayoutRow ddmFormLayoutRow) {
        ddmFormLayoutRow.setDDMFormLayoutColumns(this._getDDMFormLayoutColumns(jsonArray));
    }
}

