Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.85/js/components/FormBuilder/FormBuilder.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../util/config.es', './withActionableFields.es', './withClickableFields.es', './withEditablePageHeader.es', './withMoveableFields.es', './withMultiplePages.es', './withResizeableColumns.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.FormBuilderBase = exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

    var _metalState = require("frontend-js-metal-web$metal-state");

    var _config = require("../../util/config.es");

    var _withActionableFields = _interopRequireDefault(require("./withActionableFields.es"));

    var _withClickableFields = _interopRequireDefault(require("./withClickableFields.es"));

    var _withEditablePageHeader = _interopRequireDefault(require("./withEditablePageHeader.es"));

    var _withMoveableFields = _interopRequireDefault(require("./withMoveableFields.es"));

    var _withMultiplePages = _interopRequireDefault(require("./withMultiplePages.es"));

    var _withResizeableColumns = _interopRequireDefault(require("./withResizeableColumns.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var FormNoopAdapter = (0, _dynamicDataMappingFormRenderer.getConnectedReactComponentAdapter)(_dynamicDataMappingFormRenderer.FormNoop);
    /**
     * Builder.
     * @extends Component
     */

    var FormBuilderBase = /*#__PURE__*/function (_Component) {
      _inherits(FormBuilderBase, _Component);

      function FormBuilderBase() {
        _classCallCheck(this, FormBuilderBase);

        return _possibleConstructorReturn(this, _getPrototypeOf(FormBuilderBase).apply(this, arguments));
      }

      _createClass(FormBuilderBase, [{
        key: "attached",
        value: function attached() {
          var formBasicInfo = document.querySelector('.ddm-form-basic-info');
          var translationManager = document.querySelector('.ddm-translation-manager');

          if (formBasicInfo && translationManager) {
            formBasicInfo.classList.remove('hide');
            translationManager.classList.remove('hide');
          }
        }
      }, {
        key: "preparePagesForRender",
        value: function preparePagesForRender(pages) {
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
          return visitor.mapFields(function (field) {
            if (field.type === 'select' && !field.dataSourceType.includes('manual')) {
              field = _objectSpread(_objectSpread({}, field), {}, {
                options: [{
                  label: Liferay.Language.get('dynamically-loaded-data'),
                  value: 'dynamic'
                }],
                value: 'dynamic'
              });
            }

            return _objectSpread(_objectSpread({}, field), {}, {
              readOnly: true
            });
          }, true, true);
        }
      }, {
        key: "render",
        value: function render() {
          var props = this.props;
          var activePage = props.activePage,
              allowNestedFields = props.allowNestedFields,
              dnd = props.dnd,
              editingLanguageId = props.editingLanguageId,
              pages = props.pages,
              paginationMode = props.paginationMode,
              portletNamespace = props.portletNamespace,
              spritemap = props.spritemap,
              successPageSettings = props.successPageSettings,
              view = props.view;
          IncrementalDOM.elementOpen("div", null, null, "class", "ddm-form-builder-wrapper");
          IncrementalDOM.elementOpen("div", null, null, "class", "container ddm-form-builder");
          IncrementalDOM.elementVoid(FormNoopAdapter, null, null, "activePage", activePage, "allowNestedFields", allowNestedFields, "dnd", dnd, "editingLanguageId", editingLanguageId, "pages", this.preparePagesForRender(pages), "paginationMode", paginationMode, "portletNamespace", portletNamespace, "spritemap", spritemap, "successPageSettings", successPageSettings, "view", view, "editable", true, "ref", "FormRenderer");
          IncrementalDOM.elementClose("div");
          return IncrementalDOM.elementClose("div");
        }
      }]);

      return FormBuilderBase;
    }(_metalJsx.default);

    exports.FormBuilderBase = FormBuilderBase;
    FormBuilderBase.PROPS = {
      /**
       * @default
       * @instance
       * @memberof FormBuilder
       * @type {?number}
       */
      activePage: _metalState.Config.number().value(0),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      defaultLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?array<object>}
       */
      pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      paginationMode: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      portletNamespace: _metalState.Config.string().required(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {!string}
       */
      spritemap: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {object}
       */
      successPageSettings: _metalState.Config.shapeOf({
        body: _metalState.Config.object(),
        enabled: _metalState.Config.bool(),
        title: _metalState.Config.object()
      }).value({}),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      view: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?bool}
       */
      viewMode: _metalState.Config.bool()
    };

    var _default = (0, _dynamicDataMappingFormRenderer.compose)(_withActionableFields.default, _withClickableFields.default, _withEditablePageHeader.default, _withMoveableFields.default, _withMultiplePages.default, _withResizeableColumns.default)(FormBuilderBase);

    exports.default = _default;
    //# sourceMappingURL=FormBuilder.es.js.map
  }
});
//# sourceMappingURL=FormBuilder.es.js.map