Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.6/js/components/LayoutProvider/handlers/columnResizedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.handleColumnResized = exports.handleResizeLeft = exports.handleResizeRight = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var handleResizeRight = function handleResizeRight(state, _ref, targetColumn) {
    var columnIndex = _ref.columnIndex,
        pageIndex = _ref.pageIndex,
        rowIndex = _ref.rowIndex;
    var pages = state.pages;

    var newPages = _toConsumableArray(pages);

    var currentColumn = FormSupport.getColumn(pages, pageIndex, rowIndex, columnIndex);
    var currentPosition = FormSupport.getColumnPosition(pages, pageIndex, rowIndex, columnIndex);
    var nextColumn = FormSupport.getColumn(newPages, pageIndex, rowIndex, columnIndex + 1);
    var newCurrentColumn;

    if (nextColumn) {
      var newSize = Math.abs(currentPosition - targetColumn);
      var newNextColumn;

      if (targetColumn < currentPosition && currentColumn.size > newSize) {
        newCurrentColumn = _objectSpread({}, currentColumn, {
          size: Math.max(currentColumn.size - newSize, 1)
        });
        newNextColumn = _objectSpread({}, nextColumn, {
          size: Math.min(nextColumn.size + newSize, 12)
        });
      } else if (targetColumn > currentPosition) {
        if (nextColumn.size === 1 && nextColumn.fields.length === 0) {
          newCurrentColumn = _objectSpread({}, currentColumn, {
            size: currentColumn.size + newSize
          });
          newPages = FormSupport.removeColumn(newPages, pageIndex, rowIndex, columnIndex + 1);
        } else if (nextColumn.size > newSize) {
          newCurrentColumn = _objectSpread({}, currentColumn, {
            size: currentColumn.size + newSize
          });
          newNextColumn = _objectSpread({}, nextColumn, {
            size: nextColumn.size - newSize
          });
        }
      }

      if (newNextColumn) {
        newPages = FormSupport.updateColumn(newPages, pageIndex, rowIndex, columnIndex + 1, newNextColumn);
      }
    } else if (currentColumn.size > currentPosition - targetColumn && targetColumn < currentPosition) {
      var _newSize = currentPosition - targetColumn;

      newCurrentColumn = _objectSpread({}, currentColumn, {
        size: currentColumn.size - _newSize
      });
      newPages = FormSupport.addColumn(newPages, columnIndex + 1, pageIndex, rowIndex, {
        fields: [],
        size: _newSize
      });
    }

    if (newCurrentColumn) {
      newPages = FormSupport.updateColumn(newPages, pageIndex, rowIndex, columnIndex, newCurrentColumn);
    }

    return newPages;
  };

  exports.handleResizeRight = handleResizeRight;

  var handleResizeLeft = function handleResizeLeft(state, source, targetColumn) {
    var _FormSupport$getIndex = FormSupport.getIndexes(source),
        columnIndex = _FormSupport$getIndex.columnIndex,
        pageIndex = _FormSupport$getIndex.pageIndex,
        rowIndex = _FormSupport$getIndex.rowIndex;

    var pages = state.pages;

    var newPages = _toConsumableArray(pages);

    var currentColumn = FormSupport.getColumn(pages, pageIndex, rowIndex, columnIndex);
    var previousColumn = FormSupport.getColumn(pages, pageIndex, rowIndex, columnIndex - 1);
    var previousColumnPosition = FormSupport.getColumnPosition(pages, pageIndex, rowIndex, columnIndex - 1);

    if (previousColumn && previousColumn.fields.length == 0 && previousColumn.size === 1 && targetColumn <= previousColumnPosition) {
      newPages = FormSupport.removeColumn(newPages, pageIndex, rowIndex, columnIndex - 1);
      source.dataset.ddmFieldColumn = columnIndex - 1;
      newPages = FormSupport.updateColumn(newPages, pageIndex, rowIndex, columnIndex - 1, _objectSpread({}, currentColumn, {
        size: currentColumn.size + 1
      }));
    } else if (previousColumn) {
      var newSize = Math.abs(previousColumnPosition - targetColumn);

      if (previousColumnPosition >= targetColumn && previousColumn.size > newSize) {
        currentColumn.size += newSize;
        previousColumn.size -= newSize;
      } else if (previousColumnPosition < targetColumn && currentColumn.size > newSize) {
        currentColumn.size -= newSize;
        previousColumn.size += newSize;
      }

      newPages = FormSupport.updateColumn(newPages, pageIndex, rowIndex, columnIndex, currentColumn);
      newPages = FormSupport.updateColumn(newPages, pageIndex, rowIndex, columnIndex - 1, previousColumn);
    } else if (columnIndex === 0 && targetColumn > 0) {
      newPages = FormSupport.addColumn(newPages, columnIndex, pageIndex, rowIndex, {
        fields: [],
        size: targetColumn
      });
      newPages = FormSupport.updateColumn(newPages, pageIndex, rowIndex, columnIndex + 1, _objectSpread({}, currentColumn, {
        size: currentColumn.size - targetColumn
      }));
      source.dataset.ddmFieldColumn = columnIndex + 1;
    }

    return newPages;
  };

  exports.handleResizeLeft = handleResizeLeft;

  var handleColumnResized = function handleColumnResized(state, source, column, direction) {
    var sourceIndexes = FormSupport.getIndexes(source);
    var columnIndex = sourceIndexes.columnIndex,
        pageIndex = sourceIndexes.pageIndex,
        rowIndex = sourceIndexes.rowIndex;

    var newPages = _toConsumableArray(state.pages);

    var currentColumn = FormSupport.getColumn(newPages, pageIndex, rowIndex, columnIndex);

    if (currentColumn) {
      if (direction === 'left') {
        newPages = handleResizeLeft(state, source, column);
      } else {
        newPages = handleResizeRight(state, sourceIndexes, column + 1);
      }
    }

    newPages[pageIndex].rows = FormSupport.removeEmptyRows(newPages, pageIndex);
    return {
      pages: newPages
    };
  };

  exports.handleColumnResized = handleColumnResized;
  var _default = handleColumnResized;
  exports["default"] = _default;
  //# sourceMappingURL=columnResizedHandler.es.js.map
});
//# sourceMappingURL=columnResizedHandler.es.js.map