/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'dynamic-data-mapping-form-renderer/js/util/visitors.es';

import {sub} from './strings.es.js';

export function pageOptions(pages, maxPageIndex = 0) {
	const pageOptions = [];

	for (
		let pageIndex = maxPageIndex + 2;
		pageIndex <= pages.length;
		pageIndex++
	) {
		let pageTitle = `${pageIndex} ${sub(
			Liferay.Language.get('untitled-page-x-of-x'),
			[pageIndex, pages.length]
		)}`;

		if (pages[pageIndex - 1].title) {
			pageTitle = `${pageIndex} ${pages[pageIndex - 1].title}`;
		}

		pageOptions.push({
			label: pageTitle,
			name: pageIndex.toString(),
			value: pageIndex.toString()
		});
	}

	return pageOptions;
}

export function maxPageIndex(conditions, pages) {
	const pageIndexes = [];
	const visitor = new PagesVisitor(pages);

	if (conditions.length && conditions[0].operands[0].value) {
		conditions.forEach(condition => {
			visitor.mapFields(
				(field, fieldIndex, columnIndex, rowIndex, pageIndex) => {
					if (field.fieldName === condition.operands[0].value) {
						pageIndexes.push(pageIndex);
					}
				}
			);
		});
	}

	const maxPageIndex = Math.max(...pageIndexes);

	return isFinite(maxPageIndex) ? maxPageIndex : 0;
}
