Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.55/js/util/fieldSupport.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', './constants.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.localizeField = exports.isFieldSetChild = exports.getParentFieldSet = exports.isFieldSet = exports.getParentField = exports.getField = exports.formatFieldName = exports.createField = exports.normalizeSettingsContextPages = exports.getFieldProperties = exports.getDefaultFieldName = exports.generateInstanceId = exports.generateId = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _constants = require("./constants.es");

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var generateId = function generateId(length) {
      var allowOnlyNumbers = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var text = '';
      var possible = allowOnlyNumbers ? '0123456789' : 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

      for (var i = 0; i < length; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
      }

      return text;
    };

    exports.generateId = generateId;

    var generateInstanceId = function generateInstanceId(length) {
      return generateId(length);
    };

    exports.generateInstanceId = generateInstanceId;

    var getDefaultFieldName = function getDefaultFieldName() {
      var isOptionField = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var defaultFieldName = isOptionField ? Liferay.Language.get('option') : Liferay.Language.get('field');
      return defaultFieldName + generateId(8, true);
    };

    exports.getDefaultFieldName = getDefaultFieldName;

    var getFieldProperties = function getFieldProperties(_ref, defaultLanguageId, editingLanguageId) {
      var pages = _ref.pages;
      var properties = {};
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      visitor.mapFields(function (_ref2) {
        var fieldName = _ref2.fieldName,
            localizable = _ref2.localizable,
            _ref2$localizedValue = _ref2.localizedValue,
            localizedValue = _ref2$localizedValue === void 0 ? {} : _ref2$localizedValue,
            type = _ref2.type,
            value = _ref2.value;

        if (localizable && localizedValue[editingLanguageId] !== undefined) {
          properties[fieldName] = localizedValue[editingLanguageId];
        } else if (localizable && localizedValue[defaultLanguageId]) {
          properties[fieldName] = localizedValue[defaultLanguageId];
        } else if (type == 'options') {
          if (!value[editingLanguageId] && value[defaultLanguageId]) {
            properties[fieldName] = value[defaultLanguageId];
          } else {
            properties[fieldName] = value[editingLanguageId];
          }
        } else if (type == 'validation') {
          if (!value.errorMessage[editingLanguageId]) {
            value.errorMessage[editingLanguageId] = value.errorMessage[defaultLanguageId];
          }

          if (!value.parameter[editingLanguageId]) {
            value.parameter[editingLanguageId] = value.parameter[defaultLanguageId];
          }

          properties[fieldName] = value;
        } else {
          properties[fieldName] = value;
        }
      });
      return properties;
    };

    exports.getFieldProperties = getFieldProperties;

    var normalizeSettingsContextPages = function normalizeSettingsContextPages(pages, defaultLanguageId, editingLanguageId, fieldType, generatedFieldName) {
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      return visitor.mapFields(function (field) {
        var _field = field,
            fieldName = _field.fieldName;

        if (fieldName === 'fieldReference' || fieldName === 'name') {
          field = _objectSpread(_objectSpread({}, field), {}, {
            value: generatedFieldName
          });
        } else if (fieldName === 'label') {
          var localizedValue = _objectSpread(_objectSpread({}, field.localizedValue), {}, _defineProperty({}, editingLanguageId, fieldType.label));

          if (editingLanguageId !== defaultLanguageId && !localizedValue[defaultLanguageId]) {
            localizedValue[defaultLanguageId] = fieldType.label;
          }

          field = _objectSpread(_objectSpread({}, field), {}, {
            localizedValue: localizedValue,
            type: 'text',
            value: fieldType.label
          });
        } else if (fieldName === 'type') {
          field = _objectSpread(_objectSpread({}, field), {}, {
            value: fieldType.name
          });
        } else if (fieldName === 'validation') {
          field = _objectSpread(_objectSpread({}, field), {}, {
            validation: _objectSpread(_objectSpread({}, field.validation), {}, {
              fieldName: generatedFieldName
            })
          });
        }

        var newInstanceId = generateInstanceId(8);
        return _objectSpread(_objectSpread({}, field), {}, {
          instanceId: newInstanceId,
          name: (0, _dynamicDataMappingFormRenderer.generateName)(field.name, {
            instanceId: newInstanceId,
            repeatedIndex: (0, _dynamicDataMappingFormRenderer.getRepeatedIndex)(field.name)
          })
        });
      }, false, true);
    };

    exports.normalizeSettingsContextPages = normalizeSettingsContextPages;

    var createField = function createField(props, event) {
      var defaultLanguageId = props.defaultLanguageId,
          editingLanguageId = props.editingLanguageId,
          fieldNameGenerator = props.fieldNameGenerator,
          spritemap = props.spritemap;
      var fieldType = event.fieldType,
          _event$skipFieldNameG = event.skipFieldNameGeneration,
          skipFieldNameGeneration = _event$skipFieldNameG === void 0 ? false : _event$skipFieldNameG,
          _event$useFieldName = event.useFieldName,
          useFieldName = _event$useFieldName === void 0 ? '' : _event$useFieldName;
      var newFieldName = useFieldName;

      if (!useFieldName) {
        if (skipFieldNameGeneration) {
          var _settingsContext = fieldType.settingsContext;
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(_settingsContext.pages);
          visitor.mapFields(function (_ref3) {
            var fieldName = _ref3.fieldName,
                value = _ref3.value;

            if (fieldName === 'name') {
              newFieldName = value;
            }
          });
        } else {
          newFieldName = fieldNameGenerator(getDefaultFieldName());
        }
      }

      var newField = _objectSpread(_objectSpread({}, fieldType), {}, {
        fieldName: newFieldName,
        fieldReference: newFieldName,
        name: newFieldName,
        settingsContext: _objectSpread(_objectSpread({}, fieldType.settingsContext), {}, {
          pages: normalizeSettingsContextPages(fieldType.settingsContext.pages, defaultLanguageId, editingLanguageId, fieldType, newFieldName),
          type: fieldType.name
        })
      });

      var fieldName = newField.fieldName,
          fieldReference = newField.fieldReference,
          name = newField.name,
          settingsContext = newField.settingsContext;
      return _objectSpread(_objectSpread({}, getFieldProperties(settingsContext, defaultLanguageId, editingLanguageId)), {}, {
        fieldName: fieldName,
        fieldReference: fieldReference,
        instanceId: generateInstanceId(8),
        name: name,
        settingsContext: settingsContext,
        spritemap: spritemap,
        type: fieldType.name
      });
    };

    exports.createField = createField;

    var formatFieldName = function formatFieldName(instanceId, languageId, value) {
      return "ddm$$".concat(value, "$").concat(instanceId, "$0$$").concat(languageId);
    };

    exports.formatFieldName = formatFieldName;

    var getField = function getField(pages, fieldName) {
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      return visitor.findField(function (field) {
        return field.fieldName === fieldName;
      });
    };

    exports.getField = getField;

    var getParentField = function getParentField(pages, fieldName) {
      var parentField = null;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      visitor.visitFields(function (field) {
        var nestedFieldsVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(field.nestedFields || []);

        if (nestedFieldsVisitor.containsField(fieldName)) {
          parentField = field;
        }

        return false;
      });
      return parentField;
    };

    exports.getParentField = getParentField;

    var isFieldSet = function isFieldSet(field) {
      return field.type === _constants.FIELD_TYPE_FIELDSET && field.ddmStructureId;
    };

    exports.isFieldSet = isFieldSet;

    var getParentFieldSet = function getParentFieldSet(pages, fieldName) {
      var parentField = getParentField(pages, fieldName);

      while (parentField) {
        if (isFieldSet(parentField)) {
          return parentField;
        }

        parentField = getParentField(pages, parentField.fieldName);
      }

      return null;
    };

    exports.getParentFieldSet = getParentFieldSet;

    var isFieldSetChild = function isFieldSetChild(pages, fieldName) {
      return !!getParentFieldSet(pages, fieldName);
    };

    exports.isFieldSetChild = isFieldSetChild;

    var localizeField = function localizeField(field, defaultLanguageId, editingLanguageId) {
      var value = field.value;

      if (field.dataType === 'json' && _typeof(value) === 'object') {
        value = JSON.stringify(value);
      }

      if (field.localizable && field.localizedValue) {
        var localizedValue = field.localizedValue[editingLanguageId];

        if (localizedValue === undefined) {
          localizedValue = field.localizedValue[defaultLanguageId];
        }

        if (localizedValue !== undefined) {
          value = localizedValue;
        }
      } else if (field.dataType === 'ddm-options' && value[editingLanguageId] === undefined) {
        value = _objectSpread(_objectSpread({}, value), {}, _defineProperty({}, editingLanguageId, value[defaultLanguageId]));
      }

      return _objectSpread(_objectSpread({}, field), {}, {
        defaultLanguageId: defaultLanguageId,
        editingLanguageId: editingLanguageId,
        localizedValue: _objectSpread(_objectSpread({}, field.localizedValue || {}), {}, _defineProperty({}, editingLanguageId, value)),
        value: value
      });
    };

    exports.localizeField = localizeField;
    //# sourceMappingURL=fieldSupport.es.js.map
  }
});
//# sourceMappingURL=fieldSupport.es.js.map