Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.55/js/components/Sidebar/Sidebar.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-taglib-clay$clay-button', 'frontend-taglib-clay$clay-dropdown', 'frontend-taglib-clay$clay-icon', 'frontend-taglib-clay$clay-modal', 'dynamic-data-mapping-form-renderer', 'dynamic-data-mapping-form-renderer/js/util/fetch.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../components/RuleBuilder/RulesSupport.es', '../../util/config.es', '../../util/dom.es', '../../util/fieldSupport.es', '../FieldTypeBox/FieldTypeBox.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _clayButton = _interopRequireDefault(require("frontend-taglib-clay$clay-button"));

    var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

    var _clayIcon = require("frontend-taglib-clay$clay-icon");

    var _clayModal = _interopRequireDefault(require("frontend-taglib-clay$clay-modal"));

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _fetch = require("dynamic-data-mapping-form-renderer/js/util/fetch.es");

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

    var _metalEvents = require("frontend-js-metal-web$metal-events");

    var _metalJsx = _interopRequireWildcard(require("frontend-js-metal-web$metal-jsx"));

    var _metalState = require("frontend-js-metal-web$metal-state");

    var _RulesSupport = _interopRequireDefault(require("../../components/RuleBuilder/RulesSupport.es"));

    var _config = require("../../util/config.es");

    var _dom = require("../../util/dom.es");

    var _fieldSupport = require("../../util/fieldSupport.es");

    var _FieldTypeBox = _interopRequireDefault(require("../FieldTypeBox/FieldTypeBox.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _get(target, property, receiver) {
      if (typeof Reflect !== "undefined" && Reflect.get) {
        _get = Reflect.get;
      } else {
        _get = function _get(target, property, receiver) {
          var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
            return desc.get.call(receiver);
          }return desc.value;
        };
      }return _get(target, property, receiver || target);
    }

    function _superPropBase(object, property) {
      while (!Object.prototype.hasOwnProperty.call(object, property)) {
        object = _getPrototypeOf(object);if (object === null) break;
      }return object;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    /**
     * Sidebar is a tooling to mount forms.
     */
    var Sidebar = /*#__PURE__*/function (_Component) {
      _inherits(Sidebar, _Component);

      function Sidebar() {
        _classCallCheck(this, Sidebar);

        return _possibleConstructorReturn(this, _getPrototypeOf(Sidebar).apply(this, arguments));
      }

      _createClass(Sidebar, [{
        key: "attached",
        value: function attached() {
          this._bindDragAndDrop();

          this._eventHandler.add(_metalDom.default.on(document, 'mousedown', this._handleDocumentMouseDown, false));
        }
      }, {
        key: "changeFieldType",
        value: function changeFieldType(type) {
          var _this$props = this.props,
              defaultLanguageId = _this$props.defaultLanguageId,
              editingLanguageId = _this$props.editingLanguageId,
              fieldTypes = _this$props.fieldTypes,
              focusedField = _this$props.focusedField;
          var dispatch = this.context.dispatch;
          var newFieldType = fieldTypes.find(function (_ref) {
            var name = _ref.name;
            return name === type;
          });

          var newSettingsContext = _objectSpread(_objectSpread({}, newFieldType.settingsContext), {}, {
            pages: (0, _fieldSupport.normalizeSettingsContextPages)(newFieldType.settingsContext.pages, defaultLanguageId, editingLanguageId, newFieldType, focusedField.fieldName)
          });

          var settingsContext = focusedField.settingsContext;

          if (type !== focusedField.type) {
            settingsContext = this._mergeFieldTypeSettings(settingsContext, newSettingsContext);
          }

          dispatch('focusedFieldEvaluationEnded', _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, focusedField), newFieldType), (0, _fieldSupport.getFieldProperties)(settingsContext, defaultLanguageId, editingLanguageId)), {}, {
            changedFieldType: true,
            instanceId: (0, _dynamicDataMappingFormRenderer.generateInstanceId)(8),
            settingsContext: settingsContext,
            type: newFieldType.name
          }));
        }
      }, {
        key: "close",
        value: function close() {
          this.setState({
            open: false
          });
        }
      }, {
        key: "created",
        value: function created() {
          this._eventHandler = new _metalEvents.EventHandler();

          var transitionEnd = this._getTransitionEndEvent();

          this.supportsTransitionEnd = transitionEnd !== false;
          this.transitionEnd = transitionEnd || 'transitionend';
          this._handleChangeFieldTypeItemClicked = this._handleChangeFieldTypeItemClicked.bind(this);
          this._handleCloseButtonClicked = this._handleCloseButtonClicked.bind(this);
          this._handleDocumentMouseDown = this._handleDocumentMouseDown.bind(this);
          this._handleDragEnded = this._handleDragEnded.bind(this);
          this._handleDragStarted = this._handleDragStarted.bind(this);
          this._handleDragTargetEnter = this._handleDragTargetEnter.bind(this);
          this._handleDragTargetLeave = this._handleDragTargetLeave.bind(this);
          this._handleEvaluatorChanged = this._handleEvaluatorChanged.bind(this);
          this._handleElementSettingsClicked = this._handleElementSettingsClicked.bind(this);
          this._handlePreviousButtonClicked = this._handlePreviousButtonClicked.bind(this);
          this._handleSettingsFieldBlurred = this._handleSettingsFieldBlurred.bind(this);
          this._handleSettingsFieldEdited = this._handleSettingsFieldEdited.bind(this);
          this._handleSettingsFormAttached = this._handleSettingsFormAttached.bind(this);
          this._handleTabItemClicked = this._handleTabItemClicked.bind(this);
          this._renderFieldTypeDropdownLabel = this._renderFieldTypeDropdownLabel.bind(this);
        }
      }, {
        key: "disposeDragAndDrop",
        value: function disposeDragAndDrop() {
          if (this._dragAndDrop) {
            this._dragAndDrop.dispose();
          }
        }
      }, {
        key: "disposeInternal",
        value: function disposeInternal() {
          _get(_getPrototypeOf(Sidebar.prototype), "disposeInternal", this).call(this);

          this._eventHandler.removeAllListeners();

          this.disposeDragAndDrop();
        }
      }, {
        key: "getDropTargetsSelector",
        value: function getDropTargetsSelector() {
          return '.ddm-target:not([data-drop-disabled="true"])';
        }
      }, {
        key: "getSettingsFormContext",
        value: function getSettingsFormContext() {
          var _this$props2 = this.props,
              defaultLanguageId = _this$props2.defaultLanguageId,
              editingLanguageId = _this$props2.editingLanguageId,
              focusedField = _this$props2.focusedField,
              readOnlyFieldName = _this$props2.readOnlyFieldName;
          var settingsContext = focusedField.settingsContext;
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
          return _objectSpread(_objectSpread({}, settingsContext), {}, {
            pages: visitor.mapFields(function (field) {
              var updatedField = _objectSpread(_objectSpread({}, field), {}, {
                defaultLanguageId: defaultLanguageId,
                editingLanguageId: editingLanguageId,
                keywordReadOnly: field.fieldName == 'columns' || field.fieldName == 'options' || field.fieldName == 'rows' ? readOnlyFieldName : false,
                readOnly: field.fieldName == 'name' ? readOnlyFieldName : false,
                visible: field.fieldName !== 'name' ? field.visible : false
              });

              return _objectSpread(_objectSpread({}, updatedField), {}, {
                name: (0, _dynamicDataMappingFormRenderer.generateName)(field.name, updatedField)
              });
            })
          });
        }
      }, {
        key: "open",
        value: function open() {
          var _this = this;

          var container = this.refs.container;
          var open = this.state.open;
          var transitionEnd = this.transitionEnd;

          if (open) {
            return;
          }

          _metalDom.default.once(container, transitionEnd, function () {
            if (_this._isEditMode()) {
              var firstInput = _this.element.querySelector('input');

              if (firstInput && !container.contains(document.activeElement)) {
                firstInput.focus();
                (0, _dom.selectText)(firstInput);
              }
            }
          });

          this.setState({
            activeTab: 0,
            open: true
          });
          this.refreshDragAndDrop();
        }
      }, {
        key: "refreshDragAndDrop",
        value: function refreshDragAndDrop() {
          this._dragAndDrop.setState({
            targets: this.getDropTargetsSelector()
          });
        }
      }, {
        key: "render",
        value: function render() {
          var _this$state = this.state,
              activeTab = _this$state.activeTab,
              open = _this$state.open;
          var spritemap = this.props.spritemap;

          var editMode = this._isEditMode();

          var styles = (0, _classnames.default)('sidebar-container', {
            open: open
          });
          IncrementalDOM.elementOpen("div");
          IncrementalDOM.elementOpen("div", null, null, "class", styles, "ref", "container");
          IncrementalDOM.elementOpen("div", null, null, "class", "sidebar sidebar-light");
          IncrementalDOM.elementOpen("nav", null, null, "class", "component-tbar tbar");
          IncrementalDOM.elementOpen("div", null, null, "class", "container-fluid");
          iDOMHelpers.renderArbitrary(this._renderTopBar());
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("nav");
          IncrementalDOM.elementOpen("nav", null, null, "class", "component-navigation-bar navbar navigation-bar navbar-collapse-absolute navbar-expand-md navbar-underline");
          IncrementalDOM.elementOpen("a", null, null, "aria-controls", "sidebarLightCollapse00", "aria-expanded", "false", "aria-label", "Toggle Navigation", "class", "collapsed navbar-toggler navbar-toggler-link", "data-toggle", "liferay-collapse", "href", "#sidebarLightCollapse00", "role", "button");
          IncrementalDOM.elementOpen("span", null, null, "class", "navbar-text-truncate");
          IncrementalDOM.text("Details");
          IncrementalDOM.elementClose("span");
          IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-caret-bottom");
          IncrementalDOM.elementVoid("use", null, null, "xlink:href", "".concat(spritemap, "#caret-bottom"));
          IncrementalDOM.elementClose("svg");
          IncrementalDOM.elementClose("a");
          IncrementalDOM.elementOpen("div", null, null, "class", "collapse navbar-collapse", "id", "sidebarLightCollapse00");
          IncrementalDOM.elementOpen("ul", null, null, "class", "nav navbar-nav", "role", "tablist");
          iDOMHelpers.renderArbitrary(this._renderNavItems());
          IncrementalDOM.elementClose("ul");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("nav");
          IncrementalDOM.elementOpen("div", null, null, "class", "ddm-sidebar-body");
          iDOMHelpers.renderArbitrary(!editMode && activeTab == 0 && this._renderFieldTypeGroups());
          iDOMHelpers.renderArbitrary(!editMode && activeTab == 1 && this._renderElementSets());
          iDOMHelpers.renderArbitrary(editMode && (IncrementalDOM.elementOpen("div", null, null, "class", "sidebar-body ddm-field-settings"), (IncrementalDOM.elementOpen("div", null, null, "class", "tab-content"), (IncrementalDOM.elementOpen("form"), iDOMHelpers.renderArbitrary(this._renderSettingsForm()), IncrementalDOM.elementClose("form")), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("div")));
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementVoid(_clayModal.default, null, null, "body", Liferay.Language.get('are-you-sure-you-want-to-cancel'), "events", {
            clickButton: this._handleCancelChangesModalButtonClicked.bind(this)
          }, "footerButtons", [{
            alignment: 'right',
            label: Liferay.Language.get('dismiss'),
            style: 'primary',
            type: 'close'
          }, {
            alignment: 'right',
            label: Liferay.Language.get('yes-cancel'),
            style: 'primary',
            type: 'button'
          }], "spritemap", spritemap, "title", Liferay.Language.get('cancel-field-changes-question'), "ref", "cancelChangesModal", "size", "sm");
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "syncEditingLanguageId",
        value: function syncEditingLanguageId() {
          var dispatch = this.context.dispatch;
          var evaluableForm = this.refs.evaluableForm;
          var _this$props3 = this.props,
              editingLanguageId = _this$props3.editingLanguageId,
              focusedField = _this$props3.focusedField;

          if (evaluableForm && evaluableForm.reactComponentRef.current) {
            evaluableForm.reactComponentRef.current.evaluate(editingLanguageId).then(function (pages) {
              dispatch('focusedFieldEvaluationEnded', _objectSpread(_objectSpread({}, focusedField), {}, {
                changedEditingLanguage: true,
                settingsContext: _objectSpread(_objectSpread({}, focusedField.settingsContext), {}, {
                  pages: pages
                })
              }));
            }).catch(function (error) {
              return dispatch('evaluationError', error);
            });
          }
        }
      }, {
        key: "syncVisible",
        value: function syncVisible(visible) {
          if (!visible) {
            this.dispatchFieldBlurred();
          }
        }
      }, {
        key: "_bindDragAndDrop",
        value: function _bindDragAndDrop() {
          this._dragAndDrop = new _metalDragDrop.DragDrop({
            container: document.body,
            dragPlaceholder: _metalDragDrop.Drag.Placeholder.CLONE,
            sources: '.ddm-drag-item',
            targets: this.getDropTargetsSelector(),
            useShim: false
          });

          this._eventHandler.add(this._dragAndDrop.on(_metalDragDrop.Drag.Events.START, this._handleDragStarted), this._dragAndDrop.on(_metalDragDrop.DragDrop.Events.END, this._handleDragEnded), this._dragAndDrop.on(_metalDragDrop.DragDrop.Events.TARGET_ENTER, this._handleDragTargetEnter), this._dragAndDrop.on(_metalDragDrop.DragDrop.Events.TARGET_LEAVE, this._handleDragTargetLeave));
        }
      }, {
        key: "_cancelFieldChanges",
        value: function _cancelFieldChanges() {
          var cancelChangesModal = this.refs.cancelChangesModal;
          cancelChangesModal.show();
        }
      }, {
        key: "_deleteField",
        value: function _deleteField(fieldName) {
          var dispatch = this.context.dispatch;
          dispatch('fieldDeleted', {
            fieldName: fieldName
          });
        }
      }, {
        key: "dispatchFieldBlurred",
        value: function dispatchFieldBlurred() {
          var dispatch = this.context.dispatch;

          if (!this.isDisposed()) {
            dispatch('sidebarFieldBlurred');
          }
        }
      }, {
        key: "_dropdownFieldTypesValueFn",
        value: function _dropdownFieldTypesValueFn() {
          var fieldTypes = this.props.fieldTypes;
          return fieldTypes.filter(function (_ref2) {
            var system = _ref2.system;
            return !system;
          }).map(function (fieldType) {
            return _objectSpread(_objectSpread({}, fieldType), {}, {
              type: 'item'
            });
          });
        }
      }, {
        key: "_duplicateField",
        value: function _duplicateField(fieldName) {
          var dispatch = this.context.dispatch;
          dispatch('fieldDuplicated', {
            fieldName: fieldName
          });
        }
      }, {
        key: "_fetchElementSet",
        value: function _fetchElementSet(fieldSetId) {
          var _this$props4 = this.props,
              editingLanguageId = _this$props4.editingLanguageId,
              fieldSetDefinitionURL = _this$props4.fieldSetDefinitionURL,
              groupId = _this$props4.groupId,
              portletNamespace = _this$props4.portletNamespace;
          return (0, _fetch.makeFetch)({
            method: 'GET',
            url: "".concat(fieldSetDefinitionURL, "?ddmStructureId=").concat(fieldSetId, "&languageId=").concat(editingLanguageId, "&portletNamespace=").concat(portletNamespace, "&scopeGroupId=").concat(groupId)
          }).then(function (_ref3) {
            var pages = _ref3.pages;
            return pages;
          }).catch(function (error) {
            throw new Error(error);
          });
        }
      }, {
        key: "_fieldTypesGroupValueFn",
        value: function _fieldTypesGroupValueFn() {
          var fieldTypes = this.props.fieldTypes;
          var group = {
            basic: {
              fields: [],
              label: Liferay.Language.get('field-types-basic-elements')
            },
            customized: {
              fields: [],
              label: Liferay.Language.get('field-types-customized-elements')
            }
          };
          return fieldTypes.reduce(function (prev, next) {
            if (next.group && !next.system) {
              if (next.group === 'interface') {
                prev.basic.fields.push(next);
              } else {
                prev[next.group].fields.push(next);
              }
            }

            return prev;
          }, group);
        }
      }, {
        key: "_getTabItems",
        value: function _getTabItems() {
          if (!this._isEditMode()) {
            return this.state.tabs;
          }

          var focusedField = this.props.focusedField;
          var settingsContext = focusedField.settingsContext;
          return settingsContext.pages.map(function (_ref4) {
            var title = _ref4.title;
            return title;
          });
        }
      }, {
        key: "_getTransitionEndEvent",
        value: function _getTransitionEndEvent() {
          var el = document.createElement('metalClayTransitionEnd');
          var transitionEndEvents = {
            MozTransition: 'transitionend',
            OTransition: 'oTransitionEnd otransitionend',
            WebkitTransition: 'webkitTransitionEnd',
            transition: 'transitionend'
          };
          var eventName = false;
          Object.keys(transitionEndEvents).some(function (name) {
            if (el.style[name] !== undefined) {
              eventName = transitionEndEvents[name];
              return true;
            }
          });
          return eventName;
        }
      }, {
        key: "_handleCancelChangesModalButtonClicked",
        value: function _handleCancelChangesModalButtonClicked(event) {
          var dispatch = this.context.dispatch;
          var target = event.target;
          var cancelChangesModal = this.refs.cancelChangesModal;
          event.stopPropagation();

          if (this._isOutsideModal(target)) {
            this.close();
          }

          cancelChangesModal.emit('hide');

          if (!event.target.classList.contains('close-modal')) {
            dispatch('fieldChangesCanceled', {});
          }
        }
      }, {
        key: "_handleChangeFieldTypeItemClicked",
        value: function _handleChangeFieldTypeItemClicked(_ref5) {
          var data = _ref5.data;
          var newFieldType = data.item.name;
          this.changeFieldType(newFieldType);
        }
      }, {
        key: "_handleCloseButtonClicked",
        value: function _handleCloseButtonClicked() {
          this.close();
        }
      }, {
        key: "_handleDocumentMouseDown",
        value: function _handleDocumentMouseDown(_ref6) {
          var _this2 = this;

          var target = _ref6.target;
          var transitionEnd = this.transitionEnd;
          var open = this.state.open;
          var ckeContext = target ? target.closest('.cke_dialog_container') : undefined;

          if (this._isCloseButton(target) || open && !ckeContext && !this._isControlProductMenuItem(target) && !this._isProductMenuSidebarItem(target) && !this._isSidebarElement(target) && !this._isTranslationItem(target) && !this._isModalElement(target)) {
            this.close();

            _metalDom.default.once(this.refs.container, transitionEnd, function () {
              return _this2.dispatchFieldBlurred();
            });

            if (!this._isModalElement(target)) {
              setTimeout(function () {
                return _this2.dispatchFieldBlurred();
              }, 500);
            }
          }
        }
      }, {
        key: "_handleDragEnded",
        value: function _handleDragEnded(data, event) {
          var dispatch = this.context.dispatch;
          event.preventDefault();

          if (!data.target) {
            return;
          }

          this._handleDragTargetLeave(data);

          var fieldTypes = this.props.fieldTypes;
          var fieldSetId = data.source.dataset.fieldSetId;

          var columnNode = _metalDom.default.closest(data.target, '.col-ddm');

          var indexes = _dynamicDataMappingFormRenderer.FormSupport.getIndexes(columnNode);

          if (fieldSetId) {
            this._fetchElementSet(fieldSetId).then(function (pages) {
              dispatch('elementSetAdded', {
                data: data,
                fieldSetId: fieldSetId,
                fieldSetPages: pages,
                indexes: indexes
              });
            });
          } else {
            var fieldType = fieldTypes.find(function (_ref7) {
              var name = _ref7.name;
              return name === data.source.dataset.fieldTypeName;
            });
            var parentFieldName;

            var parentFieldNode = _metalDom.default.closest(data.target.parentElement, '.ddm-field');

            if (parentFieldNode) {
              parentFieldName = parentFieldNode.dataset.fieldName;
            }

            var payload = {
              data: _objectSpread(_objectSpread({}, data), {}, {
                fieldName: data.target.dataset.fieldName,
                parentFieldName: parentFieldName
              }),
              fieldType: _objectSpread(_objectSpread({}, fieldType), {}, {
                editable: true
              }),
              indexes: indexes
            };

            if (_metalDom.default.closest(data.target, '.col-empty')) {
              var addedToPlaceholder = _metalDom.default.closest(data.target, '.placeholder');

              dispatch('fieldAdded', _objectSpread(_objectSpread({}, payload), {}, {
                addedToPlaceholder: addedToPlaceholder
              }));
            } else {
              dispatch('sectionAdded', payload);
            }
          }
        }
      }, {
        key: "_handleDragStarted",
        value: function _handleDragStarted() {
          this.refreshDragAndDrop();
          this.close();
        }
      }, {
        key: "_handleDragTargetEnter",
        value: function _handleDragTargetEnter(_ref8) {
          var target = _ref8.target;

          var parentFieldNode = _metalDom.default.closest(target.parentElement, ".ddm-field-container");

          if (parentFieldNode) {
            parentFieldNode.classList.add('active-drop-child');
          }
        }
      }, {
        key: "_handleDragTargetLeave",
        value: function _handleDragTargetLeave(_ref9) {
          var target = _ref9.target;

          var parentFieldNode = _metalDom.default.closest(target.parentElement, ".ddm-field-container");

          if (parentFieldNode) {
            parentFieldNode.classList.remove('active-drop-child');
          }
        }
      }, {
        key: "_handleEvaluatorChanged",
        value: function _handleEvaluatorChanged(pages) {
          var dispatch = this.context.dispatch;
          var focusedField = this.props.focusedField;
          dispatch('focusedFieldEvaluationEnded', _objectSpread(_objectSpread({}, focusedField), {}, {
            settingsContext: _objectSpread(_objectSpread({}, focusedField.settingsContext), {}, {
              pages: pages
            })
          }));
        }
      }, {
        key: "_handleElementSettingsClicked",
        value: function _handleElementSettingsClicked(_ref10) {
          var item = _ref10.data.item;
          var _this$props$focusedFi = this.props.focusedField,
              columnIndex = _this$props$focusedFi.columnIndex,
              fieldName = _this$props$focusedFi.fieldName,
              pageIndex = _this$props$focusedFi.pageIndex,
              rowIndex = _this$props$focusedFi.rowIndex;
          var settingsItem = item.settingsItem;


          if (!item.disabled) {
            if (settingsItem === 'duplicate-field') {
              this._duplicateField(fieldName);
            } else if (settingsItem === 'delete-field') {
              var rules = this.props.rules;

              if (rules && _RulesSupport.default.findRuleByFieldName(fieldName, rules)) {
                var dropdown = document.querySelector('.dropdown-menu.show');
                dropdown.classList.remove('show');
              }

              this._deleteField(fieldName);
            } else if (settingsItem === 'cancel-field-changes') {
              this._cancelFieldChanges({
                columnIndex: columnIndex,
                pageIndex: pageIndex,
                rowIndex: rowIndex
              });
            }
          }
        }
      }, {
        key: "_handlePreviousButtonClicked",
        value: function _handlePreviousButtonClicked() {
          var _this3 = this;

          var transitionEnd = this.transitionEnd;
          this.close();

          _metalDom.default.once(this.refs.container, transitionEnd, function () {
            _this3.dispatchFieldBlurred();

            _this3.open();
          });
        }
      }, {
        key: "_handleSettingsFieldBlurred",
        value: function _handleSettingsFieldBlurred(_ref11) {
          var fieldInstance = _ref11.fieldInstance,
              value = _ref11.value;
          var dispatch = this.context.dispatch;
          var editingLanguageId = this.props.editingLanguageId;
          var fieldName = fieldInstance.fieldName;
          dispatch('fieldBlurred', {
            editingLanguageId: editingLanguageId,
            propertyName: fieldName,
            propertyValue: value
          });
        }
      }, {
        key: "_handleSettingsFieldEdited",
        value: function _handleSettingsFieldEdited(_ref12) {
          var fieldInstance = _ref12.fieldInstance,
              value = _ref12.value;

          if (fieldInstance && !fieldInstance.isDisposed() && this.state.open) {
            var editingLanguageId = this.props.editingLanguageId;
            var fieldName = fieldInstance.fieldName;
            var dispatch = this.context.dispatch;
            dispatch('fieldEdited', {
              editingLanguageId: editingLanguageId,
              propertyName: fieldName,
              propertyValue: value
            });
          }
        }
      }, {
        key: "_handleSettingsFormAttached",
        value: function _handleSettingsFormAttached() {
          var reactForm = this.refs.evaluableForm.reactComponentRef.current;
          var editingLanguageId = this.props.editingLanguageId;

          if (reactForm) {
            reactForm.evaluate(editingLanguageId);
          }
        }
      }, {
        key: "_handleTabItemClicked",
        value: function _handleTabItemClicked(event) {
          var target = event.target;

          var _dom$closest = _metalDom.default.closest(target, '.nav-item'),
              index = _dom$closest.dataset.index;

          event.preventDefault();
          this.setState({
            activeTab: parseInt(index, 10)
          });
        }
      }, {
        key: "_isCloseButton",
        value: function _isCloseButton(node) {
          var closeButton = this.refs.closeButton;
          return closeButton.contains(node);
        }
      }, {
        key: "_isControlProductMenuItem",
        value: function _isControlProductMenuItem(node) {
          return !!_metalDom.default.closest(node, '.sidenav-toggler');
        }
      }, {
        key: "_isEditMode",
        value: function _isEditMode() {
          var focusedField = this.props.focusedField;
          return Object.keys(focusedField).length > 0;
        }
      }, {
        key: "_isModalElement",
        value: function _isModalElement(node) {
          return _metalDom.default.closest(node, '.modal');
        }
      }, {
        key: "_isProductMenuSidebarItem",
        value: function _isProductMenuSidebarItem(node) {
          return !!_metalDom.default.closest(node, '.sidenav-menu');
        }
      }, {
        key: "_isOutsideModal",
        value: function _isOutsideModal(node) {
          return !_metalDom.default.closest(node, '.close-modal');
        }
      }, {
        key: "_isSettingsElement",
        value: function _isSettingsElement(target) {
          var fieldSettingsActions = this.refs.fieldSettingsActions;
          var dropdownPortal;

          if (fieldSettingsActions) {
            var dropdown = fieldSettingsActions.refs.dropdown;
            var portal = dropdown.refs.portal;
            dropdownPortal = portal.element.contains(target);
          }

          return dropdownPortal;
        }
      }, {
        key: "_isSidebarElement",
        value: function _isSidebarElement(node) {
          var element = this.element;

          var alloyEditorToolbarNode = _metalDom.default.closest(node, '.ae-ui');

          var fieldColumnNode = _metalDom.default.closest(node, '.col-ddm');

          var fieldTypesDropdownNode = _metalDom.default.closest(node, '.dropdown-menu');

          return alloyEditorToolbarNode || fieldTypesDropdownNode || fieldColumnNode || element.contains(node) || this._isSettingsElement(node);
        }
      }, {
        key: "_isTranslationItem",
        value: function _isTranslationItem(node) {
          return !!_metalDom.default.closest(node, '.lfr-translationmanager');
        }
      }, {
        key: "_mergeFieldTypeSettings",
        value: function _mergeFieldTypeSettings(oldSettingsContext, newSettingsContext) {
          var _this4 = this;

          var newVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(newSettingsContext.pages);
          var oldVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(oldSettingsContext.pages);
          var excludedFields = ['indexType', 'readOnly', 'type', 'validation'];

          var getPreviousField = function getPreviousField(_ref13) {
            var fieldName = _ref13.fieldName,
                type = _ref13.type;
            var field;
            oldVisitor.findField(function (oldField) {
              if (excludedFields.indexOf(fieldName) === -1 && oldField.fieldName === fieldName && oldField.type === type) {
                field = oldField;
              }

              return field;
            });
            return field;
          };

          return _objectSpread(_objectSpread({}, newSettingsContext), {}, {
            pages: newVisitor.mapFields(function (newField) {
              if (newField.visible) {
                var previousField = getPreviousField(newField);

                if (previousField) {
                  newField.value = previousField.value;

                  if (newField.localizable && previousField.localizable) {
                    newField.localizedValue = _objectSpread({}, previousField.localizedValue);
                  }
                }

                if (newField.fieldName == 'predefinedValue') {
                  delete newField.value;
                  newField.localizedValue = {};

                  if (newField.options) {
                    newField.options = _this4._getPredefinedOptions(newVisitor);
                  }
                }
              }

              return newField;
            })
          });
        }
      }, {
        key: "_getPredefinedOptions",
        value: function _getPredefinedOptions(visitor) {
          var options = visitor.findField(function (field) {
            return field.fieldName == 'options';
          });

          if (options) {
            var locale = options.locale;
            return options.value[locale];
          }

          return options;
        }
      }, {
        key: "_renderElementSets",
        value: function _renderElementSets() {
          var fieldSets = this.props.fieldSets;
          var groups = Object.keys(fieldSets);
          var elementSetsArea = '';

          if (groups.length > 0) {
            elementSetsArea = this._renderElementSetsGroups(groups);
          } else {
            elementSetsArea = this._renderEmptyElementSets();
          }

          return elementSetsArea;
        }
      }, {
        key: "_renderElementSetsGroups",
        value: function _renderElementSetsGroups(groups) {
          var _this$props5 = this.props,
              fieldSets = _this$props5.fieldSets,
              spritemap = _this$props5.spritemap;
          IncrementalDOM.elementOpen("div", null, null, "aria-orientation", "vertical", "class", "ddm-field-types-panel panel-group", "id", "accordion03", "role", "tablist");
          iDOMHelpers.renderArbitrary(groups.map(function (key) {
            return iDOMHelpers.jsxWrapper(function (_ddmFieldTypes$co, _ddmFieldTypes$con, _key, _fieldSets$key$id, _fieldSets$key$name, _fieldType_$concat, _fieldType_$concat2, _lexiconIconLexicon, _$concat$concat, _fieldSets$key$name2) {
              IncrementalDOM.elementOpen("div", _key, ["class", "panel-collapse show", "key", _key, "role", "tabpanel"], "aria-labelledby", _ddmFieldTypes$co, "id", _ddmFieldTypes$con);
              IncrementalDOM.elementOpen("div", null, null, "class", "panel-body p-0 m-0 list-group");
              IncrementalDOM.elementOpen("div", _fieldType_$concat, ["class", "ddm-drag-item list-group-item list-group-item-flex", "key", _fieldType_$concat], "data-field-set-id", _fieldSets$key$id, "data-field-set-name", _fieldSets$key$name, "ref", _fieldType_$concat2);
              IncrementalDOM.elementOpen("div", null, null, "class", "autofit-col");
              IncrementalDOM.elementOpen("span", null, null, "class", "sticker sticker-secondary");
              IncrementalDOM.elementOpen("span", null, null, "class", "inline-item");
              IncrementalDOM.elementOpen("svg", null, null, "class", _lexiconIconLexicon, "aria-hidden", "true");
              IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat$concat);
              IncrementalDOM.elementClose("svg");
              IncrementalDOM.elementClose("span");
              IncrementalDOM.elementClose("span");
              IncrementalDOM.elementClose("div");
              IncrementalDOM.elementOpen("div", null, null, "class", "autofit-col autofit-col-expand");
              IncrementalDOM.elementOpen("h4", null, null, "class", "list-group-title text-truncate");
              IncrementalDOM.elementOpen("span");
              iDOMHelpers.renderArbitrary(_fieldSets$key$name2);
              IncrementalDOM.elementClose("span");
              IncrementalDOM.elementClose("h4");
              IncrementalDOM.elementClose("div");
              IncrementalDOM.elementClose("div");
              IncrementalDOM.elementClose("div");
              return IncrementalDOM.elementClose("div");
            }, ["#ddm-field-types-".concat(key, "-header"), "ddm-field-types-".concat(key, "-body"), key, fieldSets[key].id, fieldSets[key].name, "fieldType_".concat(fieldSets[key].name), "fieldType_".concat(fieldSets[key].name), "lexicon-icon lexicon-icon-".concat(fieldSets[key].icon), "".concat(spritemap, "#").concat(fieldSets[key].icon), fieldSets[key].name]);
          }));
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "_renderEmptyElementSets",
        value: function _renderEmptyElementSets() {
          IncrementalDOM.elementOpen("div", null, null, "class", "list-group-body  list-group");
          IncrementalDOM.elementOpen("div", null, null, "class", "main-content-body");
          IncrementalDOM.elementOpen("div", null, null, "class", "text-center text-muted");
          IncrementalDOM.elementOpen("p", null, null, "class", "text-default");
          iDOMHelpers.renderArbitrary(Liferay.Language.get('there-are-no-element-sets-yet'));
          IncrementalDOM.elementClose("p");
          IncrementalDOM.elementClose("div");
          IncrementalDOM.elementClose("div");
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "_renderFieldTypeDropdownLabel",
        value: function _renderFieldTypeDropdownLabel() {
          var _this$props6 = this.props,
              fieldTypes = _this$props6.fieldTypes,
              focusedField = _this$props6.focusedField,
              spritemap = _this$props6.spritemap;

          var _fieldTypes$find = fieldTypes.find(function (_ref14) {
            var name = _ref14.name;
            return name === focusedField.type;
          }),
              icon = _fieldTypes$find.icon,
              label = _fieldTypes$find.label;

          IncrementalDOM.elementOpen(_metalJsx.Fragment);
          IncrementalDOM.elementVoid(_clayIcon.ClayIcon, null, null, "spritemap", spritemap, "symbol", icon, "elementClasses", 'inline-item inline-item-before');
          iDOMHelpers.renderArbitrary(label);
          IncrementalDOM.elementVoid(_clayIcon.ClayIcon, null, null, "spritemap", spritemap, "elementClasses", 'inline-item inline-item-after', "symbol", 'caret-bottom');
          return IncrementalDOM.elementClose(_metalJsx.Fragment);
        }
      }, {
        key: "_renderFieldTypeGroups",
        value: function _renderFieldTypeGroups() {
          var spritemap = this.props.spritemap;
          var fieldTypesGroup = this.state.fieldTypesGroup;
          var group = Object.keys(fieldTypesGroup);
          IncrementalDOM.elementOpen("div", null, null, "aria-orientation", "vertical", "class", "ddm-field-types-panel panel-group", "id", "accordion03", "role", "tablist");
          iDOMHelpers.renderArbitrary(group.map(function (key, index) {
            return iDOMHelpers.jsxWrapper(function (_fieldsGroup$concat, _ddmFieldTypes$co2, _ddmFieldTypes$con2, _fieldTypesGroup$key$, _$concat, _$concat2, _ddmFieldTypes$co3, _ddmFieldTypes$con3, _fieldTypesGroup$key$2) {
              IncrementalDOM.elementOpen("div", _fieldsGroup$concat, ["class", "panel panel-secondary", "key", _fieldsGroup$concat]);
              IncrementalDOM.elementOpen("a", null, null, "href", _ddmFieldTypes$co2, "id", _ddmFieldTypes$con2, "aria-controls", "collapseTwo", "aria-expanded", "true", "class", "collapse-icon panel-header panel-header-link", "data-parent", "#accordion03", "data-toggle", "liferay-collapse", "role", "tab");
              IncrementalDOM.elementOpen("span", null, null, "class", "panel-title");
              iDOMHelpers.renderArbitrary(_fieldTypesGroup$key$);
              IncrementalDOM.elementClose("span");
              IncrementalDOM.elementOpen("span", null, null, "class", "collapse-icon-closed");
              IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-angle-right");
              IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat);
              IncrementalDOM.elementClose("svg");
              IncrementalDOM.elementClose("span");
              IncrementalDOM.elementOpen("span", null, null, "class", "collapse-icon-open");
              IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-angle-down");
              IncrementalDOM.elementVoid("use", null, null, "xlink:href", _$concat2);
              IncrementalDOM.elementClose("svg");
              IncrementalDOM.elementClose("span");
              IncrementalDOM.elementClose("a");
              IncrementalDOM.elementOpen("div", null, null, "aria-labelledby", _ddmFieldTypes$co3, "id", _ddmFieldTypes$con3, "class", "panel-collapse show", "role", "tabpanel");
              IncrementalDOM.elementOpen("div", null, null, "class", "panel-body p-0 m-0 list-group");
              iDOMHelpers.renderArbitrary(_fieldTypesGroup$key$2);
              IncrementalDOM.elementClose("div");
              IncrementalDOM.elementClose("div");
              return IncrementalDOM.elementClose("div");
            }, ["fields-group-".concat(key, "-").concat(index), "#ddm-field-types-".concat(key, "-body"), "ddm-field-types-".concat(key, "-header"), fieldTypesGroup[key].label, "".concat(spritemap, "#angle-right"), "".concat(spritemap, "#angle-down"), "#ddm-field-types-".concat(key, "-header"), "ddm-field-types-".concat(key, "-body"), fieldTypesGroup[key].fields.map(function (fieldType) {
              return iDOMHelpers.jsxWrapper(function (_fieldType, _fieldType$name, _spritemap) {
                return IncrementalDOM.elementVoid(_FieldTypeBox.default, _fieldType$name, ["key", _fieldType$name], "fieldType", _fieldType, "spritemap", _spritemap);
              }, [fieldType, fieldType.name, spritemap]);
            })]);
          }));
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "_renderNavItems",
        value: function _renderNavItems() {
          var _this5 = this;

          var activeTab = this.state.activeTab;
          return this._getTabItems().map(function (name, index) {
            var _tab$concat;

            var style = (0, _classnames.default)('nav-link', {
              active: index === activeTab
            });
            IncrementalDOM.elementOpen("li", _tab$concat = "tab".concat(index), ["class", "nav-item", "key", _tab$concat], "data-index", index, "data-onclick", _this5._handleTabItemClicked, "ref", "tab".concat(index));
            IncrementalDOM.elementOpen("a", null, null, "class", style, "aria-controls", "sidebarLightDetails", "href", "javascript:;", "role", "tab");
            IncrementalDOM.elementOpen("span", null, null, "class", "navbar-text-truncate");
            iDOMHelpers.renderArbitrary(name);
            IncrementalDOM.elementClose("span");
            IncrementalDOM.elementClose("a");
            return IncrementalDOM.elementClose("li");
          });
        }
      }, {
        key: "_renderSettingsForm",
        value: function _renderSettingsForm() {
          var activeTab = this.state.activeTab;
          var _this$props7 = this.props,
              defaultLanguageId = _this$props7.defaultLanguageId,
              editingLanguageId = _this$props7.editingLanguageId,
              portletNamespace = _this$props7.portletNamespace,
              builderRules = _this$props7.rules,
              spritemap = _this$props7.spritemap;

          var _this$getSettingsForm = this.getSettingsFormContext(),
              pages = _this$getSettingsForm.pages,
              rules = _this$getSettingsForm.rules;

          var sidebarTabIndex = pages.length - 1;

          if (sidebarTabIndex < activeTab) {
            this.setState({
              activeTab: sidebarTabIndex
            });
          }

          return IncrementalDOM.elementVoid(_dynamicDataMappingFormRenderer.Form, null, null, "activePage", activeTab, "builderRules", builderRules, "defaultLanguageId", defaultLanguageId, "editingLanguageId", editingLanguageId, "events", {
            attached: this._handleSettingsFormAttached,
            evaluated: this._handleEvaluatorChanged,
            fieldBlurred: this._handleSettingsFieldBlurred,
            fieldEdited: this._handleSettingsFieldEdited
          }, "pages", pages, "portletNamespace", portletNamespace, "rules", rules, "spritemap", spritemap, "editable", true, "paginationMode", "tabbed", "ref", "evaluableForm");
        }
      }, {
        key: "_renderTopBar",
        value: function _renderTopBar() {
          var _this$props8 = this.props,
              fieldTypes = _this$props8.fieldTypes,
              focusedField = _this$props8.focusedField,
              spritemap = _this$props8.spritemap;

          var editMode = this._isEditMode();

          var fieldActions = [{
            label: Liferay.Language.get('duplicate-field'),
            settingsItem: 'duplicate-field'
          }, {
            label: Liferay.Language.get('remove-field'),
            settingsItem: 'delete-field'
          }, {
            label: Liferay.Language.get('cancel-field-changes'),
            settingsItem: 'cancel-field-changes'
          }];
          var focusedFieldType = fieldTypes.find(function (_ref15) {
            var name = _ref15.name;
            return name === focusedField.type;
          });
          var previousButtonEvents = {
            click: this._handlePreviousButtonClicked
          };
          IncrementalDOM.elementOpen("ul", null, null, "class", "tbar-nav");
          iDOMHelpers.renderArbitrary(!editMode && (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item tbar-item-expand text-left"), (IncrementalDOM.elementOpen("div", null, null, "class", "tbar-section"), (IncrementalDOM.elementOpen("span", null, null, "class", "text-truncate-inline"), (IncrementalDOM.elementOpen("span", null, null, "class", "text-truncate"), iDOMHelpers.renderArbitrary(Liferay.Language.get('add-elements')), IncrementalDOM.elementClose("span")), IncrementalDOM.elementClose("span")), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("li")));
          iDOMHelpers.renderArbitrary(editMode && (IncrementalDOM.elementOpen(_metalJsx.Fragment), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item"), IncrementalDOM.elementVoid(_clayButton.default, null, null, "events", previousButtonEvents, "spritemap", spritemap, "elementClasses", "nav-link", "icon", "angle-left", "ref", "previousButton", "size", "sm", "style", "secondary"), IncrementalDOM.elementClose("li")), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item ddm-fieldtypes-dropdown tbar-item-expand text-left"), (IncrementalDOM.elementOpen("div"), IncrementalDOM.elementVoid(_clayDropdown.ClayDropdownBase, null, null, "events", {
            itemClicked: this._handleChangeFieldTypeItemClicked
          }, "icon", focusedFieldType.icon, "items", this.state.dropdownFieldTypes, "label", this._renderFieldTypeDropdownLabel, "spritemap", spritemap, "itemsIconAlignment", 'left', "style", 'secondary', "triggerClasses", 'nav-link btn-sm'), IncrementalDOM.elementClose("div")), IncrementalDOM.elementClose("li")), (IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item"), IncrementalDOM.elementVoid(_clayDropdown.ClayActionsDropdown, null, null, "events", {
            itemClicked: this._handleElementSettingsClicked
          }, "items", fieldActions, "spritemap", spritemap, "ref", "fieldSettingsActions", "triggerClasses", 'component-action'), IncrementalDOM.elementClose("li")), IncrementalDOM.elementClose(_metalJsx.Fragment)));
          IncrementalDOM.elementOpen("li", null, null, "class", "tbar-item");
          IncrementalDOM.elementOpen("a", null, null, "data-onclick", this._handleCloseButtonClicked, "class", "component-action sidebar-close", "href", "javascript:;", "ref", "closeButton", "role", "button");
          IncrementalDOM.elementOpen("svg", null, null, "aria-hidden", "true", "class", "lexicon-icon lexicon-icon-times");
          IncrementalDOM.elementVoid("use", null, null, "xlink:href", "".concat(spritemap, "#times"));
          IncrementalDOM.elementClose("svg");
          IncrementalDOM.elementClose("a");
          IncrementalDOM.elementClose("li");
          return IncrementalDOM.elementClose("ul");
        }
      }]);

      return Sidebar;
    }(_metalJsx.default);

    Sidebar.STATE = {
      /**
       * @default 0
       * @instance
       * @memberof Sidebar
       * @type {?number}
       */
      activeTab: _metalState.Config.number().value(0).internal(),

      /**
       * @default _dropdownFieldTypesValueFn
       * @instance
       * @memberof Sidebar
       * @type {?array}
       */
      dropdownFieldTypes: _metalState.Config.array().valueFn('_dropdownFieldTypesValueFn'),

      /**
       * @instance
       * @memberof Sidebar
       * @type {array}
       */
      fieldTypesGroup: _metalState.Config.object().valueFn('_fieldTypesGroupValueFn'),

      /**
       * @default false
       * @instance
       * @memberof Sidebar
       * @type {?bool}
       */
      open: _metalState.Config.bool().internal().value(false),

      /**
       * @default object
       * @instance
       * @memberof Sidebar
       * @type {?object}
       */
      tabs: _metalState.Config.object().value([Liferay.Language.get('elements'), Liferay.Language.get('element-sets')]).internal()
    };
    Sidebar.PROPS = {
      /**
       * @default undefined
       * @instance
       * @memberof Sidebar
       * @type {?string}
       */
      defaultLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof Sidebar
       * @type {?string}
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof Sidebar
       * @type {?string}
       */
      fieldSetDefinitionURL: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof Sidebar
       * @type {?(array|undefined)}
       */
      fieldSets: _metalState.Config.array().value([]),

      /**
       * @default []
       * @instance
       * @memberof Sidebar
       * @type {?(array|undefined)}
       */
      fieldTypes: _metalState.Config.array().value([]),

      /**
       * @default {}
       * @instance
       * @memberof Sidebar
       * @type {?object}
       */
      focusedField: _config.focusedFieldStructure.value({}),

      /**
       * @default undefined
       * @instance
       * @memberof Sidebar
       * @type {?string}
       */
      portletNamespace: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof Sidebar
       * @type {?bool}
       */
      readOnlyFieldName: _metalState.Config.bool().value(true),

      /**
       * @default undefined
       * @instance
       * @memberof Sidebar
       * @type {?(string|undefined)}
       */
      spritemap: _metalState.Config.string().required()
    };
    var _default = Sidebar;
    exports.default = _default;
    //# sourceMappingURL=Sidebar.es.js.map
  }
});
//# sourceMappingURL=Sidebar.es.js.map