Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.55/js/components/RuleBuilder/RulesSupport.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../util/regex.es', '../LayoutProvider/util/fields.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _regex = require("../../util/regex.es");

    var _fields = require("../LayoutProvider/util/fields.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var clearTargetValue = function clearTargetValue(actions, index) {
      if (actions[index]) {
        actions[index].target = '';
      }

      return actions;
    };

    var clearFirstOperandValue = function clearFirstOperandValue(condition) {
      if (condition && condition.operands[0]) {
        condition.operands[0].type = '';
        condition.operands[0].value = '';
      }

      return condition;
    };

    var clearOperatorValue = function clearOperatorValue(condition) {
      if (condition) {
        condition.operator = '';
      }

      return condition;
    };

    var clearSecondOperandValue = function clearSecondOperandValue(condition) {
      if (condition && condition.operands[1]) {
        condition.operands[1].type = '';
        condition.operands[1].value = '';
      }

      return condition;
    };

    var clearAllConditionFieldValues = function clearAllConditionFieldValues(condition) {
      condition = clearFirstOperandValue(condition);
      condition = clearOperatorValue(condition);
      condition = clearSecondOperandValue(condition);
      return condition;
    };

    var fieldWithOptions = function fieldWithOptions(fieldType) {
      return fieldType === 'radio' || fieldType === 'checkbox_multiple' || fieldType === 'select';
    };

    var getFieldType = function getFieldType(fieldName, pages) {
      return (0, _fields.getFieldProperty)(pages, fieldName, 'type');
    };

    var optionBelongsToRule = function optionBelongsToRule(condition, options) {
      return options.some(function (option) {
        return option.value === condition.operands[1].value;
      });
    };

    var getExpressionFields = function getExpressionFields(action) {
      var regex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _regex.DEFAULT_FIELD_NAMES_REGEX_FOR_EXPRESSION;
      return action.expression.match(regex);
    };

    var targetFieldExists = function targetFieldExists(target, pages) {
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      var targetFieldExists = false;
      visitor.mapFields(function (_ref) {
        var fieldName = _ref.fieldName;

        if (target === fieldName) {
          targetFieldExists = true;
        }
      }, true, true);
      return targetFieldExists;
    };

    var syncActions = function syncActions(pages, actions) {
      actions.forEach(function (action) {
        if (action.action === 'auto-fill') {
          var inputs = action.inputs,
              outputs = action.outputs;
          Object.keys(inputs).filter(function (key) {
            return !targetFieldExists(inputs[key], pages);
          }).map(function (key) {
            inputs[key] = '';
          });
          Object.keys(outputs).filter(function (key) {
            return !targetFieldExists(outputs[key], pages);
          }).map(function (key) {
            outputs[key] = '';
          });
        } else if (action.action === 'calculate') {
          var expressionFields = getExpressionFields(action);

          if (expressionFields && expressionFields.length > 0) {
            expressionFields.forEach(function (field) {
              if (!targetFieldExists(field, pages)) {
                var inexistentField = new RegExp(field, 'g');
                action.expression = action.expression.replace(inexistentField, '');
              }
            });
          }

          if (!targetFieldExists(action.target, pages)) {
            action.target = '';
          }
        } else if (action.action === 'jump-to-page') {
          var target = parseInt(action.target, 10) + 1;

          if (pages.length < 3 || target > pages.length) {
            action.target = '';
          }
        } else if (!targetFieldExists(action.target, pages)) {
          action.target = '';
        }
      });
      return actions;
    };

    var getFieldOptions = function getFieldOptions(fieldName, pages) {
      var options = [];
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      var field = visitor.findField(function (field) {
        return field.fieldName === fieldName;
      });
      options = field ? field.options : [];
      return options;
    };

    var formatRules = function formatRules(pages, rules) {
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      var formattedRules = (rules || []).map(function (rule) {
        var actions = rule.actions,
            conditions = rule.conditions;
        conditions.forEach(function (condition) {
          var firstOperandFieldExists = false;
          var secondOperandFieldExists = false;
          var secondOperand = condition.operands[1];
          visitor.mapFields(function (_ref2) {
            var fieldName = _ref2.fieldName;

            if (condition.operands[0].value === fieldName) {
              firstOperandFieldExists = true;
            }

            if (secondOperand && secondOperand.value === fieldName) {
              secondOperandFieldExists = true;
            }
          }, true, true);
          var firstOperandFieldType = getFieldType(condition.operands[0].value, pages);

          if (firstOperandFieldExists && fieldWithOptions(firstOperandFieldType) && condition.operands[1].type != 'field') {
            var fieldName = condition.operands[0].value;
            var options = getFieldOptions(fieldName, pages);
            secondOperandFieldExists = options && optionBelongsToRule(condition, options);
          }

          if (condition.operands.length < 2 && condition.operands[0].type === 'list') {
            condition.operands = [{
              label: 'user',
              repeatable: false,
              type: 'user',
              value: 'user'
            }, _objectSpread(_objectSpread({}, condition.operands[0]), {}, {
              label: condition.operands[0].value
            })];
          }

          if (condition.operands[0].value === 'user') {
            firstOperandFieldExists = true;
          }

          if (!firstOperandFieldExists) {
            clearAllConditionFieldValues(condition);
          }

          if (fieldWithOptions(firstOperandFieldType) && !secondOperandFieldExists) {
            clearSecondOperandValue(condition);
          }

          if (!secondOperandFieldExists && secondOperand && secondOperand.type === 'field') {
            clearSecondOperandValue(condition);
          }
        });
        return _objectSpread(_objectSpread({}, rule), {}, {
          actions: syncActions(pages, actions),
          conditions: conditions
        });
      });
      return formattedRules;
    };

    var fieldNameBelongsToAction = function fieldNameBelongsToAction(fieldName, actions) {
      return actions.map(function (action) {
        if (action.action === 'auto-fill') {
          return Object.values(action.inputs).some(function (input) {
            return input === fieldName;
          }) || Object.values(action.outputs).some(function (output) {
            return output === fieldName;
          });
        } else if (action.action === 'calculate') {
          var expression = action.expression,
              target = action.target;

          if (fieldName === '') {
            return expression.indexOf('[]') !== -1 || target === fieldName;
          } else {
            return expression.indexOf(fieldName) !== -1 || target === fieldName;
          }
        } else {
          return action.target === fieldName;
        }
      }).some(function (fieldFound) {
        return fieldFound === true;
      });
    };

    var fieldNameBelongsToCondition = function fieldNameBelongsToCondition(fieldName, conditions) {
      return conditions.map(function (condition) {
        return condition.operands.map(function (operand) {
          return operand.value === fieldName;
        }).some(function (fieldFound) {
          return fieldFound === true;
        });
      }).some(function (fieldFound) {
        return fieldFound === true;
      });
    };

    var findRuleByFieldName = function findRuleByFieldName(fieldName, rules) {
      return rules.some(function (rule) {
        return fieldNameBelongsToAction(fieldName, rule.actions) || fieldNameBelongsToCondition(fieldName, rule.conditions);
      });
    };

    var findInvalidRule = function findInvalidRule(rule) {
      return findRuleByFieldName('', [rule]);
    };

    var _default = {
      clearAllConditionFieldValues: clearAllConditionFieldValues,
      clearFirstOperandValue: clearFirstOperandValue,
      clearOperatorValue: clearOperatorValue,
      clearSecondOperandValue: clearSecondOperandValue,
      clearTargetValue: clearTargetValue,
      findInvalidRule: findInvalidRule,
      findRuleByFieldName: findRuleByFieldName,
      formatRules: formatRules,
      getFieldOptions: getFieldOptions,
      getFieldType: getFieldType,
      syncActions: syncActions
    };
    exports.default = _default;
    //# sourceMappingURL=RulesSupport.es.js.map
  }
});
//# sourceMappingURL=RulesSupport.es.js.map