Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.55/js/components/LayoutProvider/util/settingsContext.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/fieldSupport.es', './fields.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.updateField = exports.updateFieldOptions = exports.updateFieldProperty = exports.updateFieldLabel = exports.updateFieldDataType = exports.updateFieldReference = exports.updateFieldName = exports.updateSettingsContextInstanceId = exports.updateSettingsContextProperty = exports.setFieldReferenceErrorMessage = exports.getSettingsContextProperty = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _fieldSupport = require("../../../util/fieldSupport.es");

    var _fields = require("./fields.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var getSettingsContextProperty = function getSettingsContextProperty(settingsContext, propertyName) {
      var propertyType = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'value';
      var propertyValue;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
      visitor.mapFields(function (field) {
        if (propertyName === field.fieldName) {
          propertyValue = field[propertyType];
        }
      });
      return propertyValue;
    };

    exports.getSettingsContextProperty = getSettingsContextProperty;

    var setFieldReferenceErrorMessage = function setFieldReferenceErrorMessage(settingsContext, propertyName) {
      var displayErrors = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      var shouldUpdateValue = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
      return _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: visitor.mapFields(function (field) {
          if (propertyName === field.fieldName) {
            field = _objectSpread(_objectSpread({}, field), {}, {
              displayErrors: displayErrors,
              errorMessage: Liferay.Language.get('this-reference-is-already-being-used'),
              shouldUpdateValue: shouldUpdateValue,
              valid: !displayErrors
            });
          }

          return field;
        })
      });
    };

    exports.setFieldReferenceErrorMessage = setFieldReferenceErrorMessage;

    var updateSettingsContextProperty = function updateSettingsContextProperty(editingLanguageId, settingsContext, propertyName, propertyValue) {
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
      return _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: visitor.mapFields(function (field) {
          if (propertyName === field.fieldName) {
            field = _objectSpread(_objectSpread({}, field), {}, {
              value: propertyValue
            });

            if (field.localizable) {
              field.localizedValue = _objectSpread(_objectSpread({}, field.localizedValue), {}, _defineProperty({}, editingLanguageId, propertyValue));
            }
          }

          return field;
        })
      });
    };

    exports.updateSettingsContextProperty = updateSettingsContextProperty;

    var updateSettingsContextInstanceId = function updateSettingsContextInstanceId(_ref) {
      var settingsContext = _ref.settingsContext;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
      return _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: visitor.mapFields(function (field) {
          var newField = _objectSpread(_objectSpread({}, field), {}, {
            instanceId: (0, _dynamicDataMappingFormRenderer.generateInstanceId)(8)
          });

          return newField;
        })
      });
    };

    exports.updateSettingsContextInstanceId = updateSettingsContextInstanceId;

    var updateFieldName = function updateFieldName(editingLanguageId, fieldNameGenerator, focusedField, value) {
      var _focusedField = focusedField,
          fieldName = _focusedField.fieldName;
      var normalizedFieldName = (0, _dynamicDataMappingFormRenderer.normalizeFieldName)(value);
      var newFieldName;

      if (normalizedFieldName !== '') {
        newFieldName = fieldNameGenerator(value, fieldName);
      } else {
        newFieldName = fieldNameGenerator((0, _fieldSupport.getDefaultFieldName)(), fieldName);
      }

      if (newFieldName) {
        var _focusedField2 = focusedField,
            settingsContext = _focusedField2.settingsContext;
        settingsContext = _objectSpread(_objectSpread({}, settingsContext), {}, {
          pages: (0, _fields.updateFieldValidationProperty)(settingsContext.pages, fieldName, 'fieldName', newFieldName)
        });
        focusedField = _objectSpread(_objectSpread({}, focusedField), {}, {
          fieldName: newFieldName,
          name: newFieldName,
          settingsContext: updateSettingsContextProperty(editingLanguageId, settingsContext, 'name', newFieldName)
        });
      }

      return focusedField;
    };

    exports.updateFieldName = updateFieldName;

    var updateFieldReference = function updateFieldReference(focusedField) {
      var invalid = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var shouldUpdateValue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var _focusedField3 = focusedField,
          settingsContext = _focusedField3.settingsContext;
      focusedField = _objectSpread(_objectSpread({}, focusedField), {}, {
        settingsContext: setFieldReferenceErrorMessage(settingsContext, 'fieldReference', invalid, shouldUpdateValue)
      });
      return focusedField;
    };

    exports.updateFieldReference = updateFieldReference;

    var updateFieldDataType = function updateFieldDataType(editingLanguageId, focusedField, value) {
      var settingsContext = focusedField.settingsContext;
      settingsContext = _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: (0, _fields.updateFieldValidationProperty)(settingsContext.pages, focusedField.fieldName, 'dataType', value)
      });
      return _objectSpread(_objectSpread({}, focusedField), {}, {
        dataType: value,
        settingsContext: updateSettingsContextProperty(editingLanguageId, settingsContext, 'dataType', value)
      });
    };

    exports.updateFieldDataType = updateFieldDataType;

    var updateFieldLabel = function updateFieldLabel(defaultLanguageId, editingLanguageId, fieldNameGenerator, focusedField, generateFieldNameUsingFieldLabel, value) {
      var fieldName = focusedField.fieldName,
          settingsContext = focusedField.settingsContext;

      if (generateFieldNameUsingFieldLabel && defaultLanguageId === editingLanguageId) {
        var updates = updateFieldName(editingLanguageId, fieldNameGenerator, focusedField, value);
        fieldName = updates.fieldName;
        settingsContext = updates.settingsContext;
      }

      return _objectSpread(_objectSpread({}, focusedField), {}, {
        fieldName: fieldName,
        label: value,
        settingsContext: updateSettingsContextProperty(editingLanguageId, settingsContext, 'label', value)
      });
    };

    exports.updateFieldLabel = updateFieldLabel;

    var updateFieldProperty = function updateFieldProperty(editingLanguageId, focusedField, propertyName, propertyValue) {
      var _objectSpread3;

      return _objectSpread(_objectSpread({}, focusedField), {}, (_objectSpread3 = {}, _defineProperty(_objectSpread3, propertyName, propertyValue), _defineProperty(_objectSpread3, "settingsContext", updateSettingsContextProperty(editingLanguageId, focusedField.settingsContext, propertyName, propertyValue)), _objectSpread3));
    };

    exports.updateFieldProperty = updateFieldProperty;

    var updateFieldOptions = function updateFieldOptions(editingLanguageId, focusedField, value) {
      var options = value[editingLanguageId];
      return _objectSpread(_objectSpread({}, focusedField), {}, {
        options: options,
        settingsContext: updateSettingsContextProperty(editingLanguageId, focusedField.settingsContext, 'options', value)
      });
    };

    exports.updateFieldOptions = updateFieldOptions;

    var updateField = function updateField(_ref2, field, propertyName, propertyValue) {
      var defaultLanguageId = _ref2.defaultLanguageId,
          editingLanguageId = _ref2.editingLanguageId,
          fieldNameGenerator = _ref2.fieldNameGenerator,
          generateFieldNameUsingFieldLabel = _ref2.generateFieldNameUsingFieldLabel;

      if (propertyName === 'dataType') {
        field = _objectSpread(_objectSpread({}, field), updateFieldDataType(editingLanguageId, field, propertyValue));
      } else if (propertyName === 'label') {
        field = _objectSpread(_objectSpread({}, field), updateFieldLabel(defaultLanguageId, editingLanguageId, fieldNameGenerator, field, generateFieldNameUsingFieldLabel, propertyValue));
      } else if (propertyName === 'name') {
        field = _objectSpread(_objectSpread({}, field), updateFieldName(editingLanguageId, fieldNameGenerator, field, propertyValue));
      } else if (propertyName === 'options') {
        field = _objectSpread(_objectSpread({}, field), updateFieldOptions(editingLanguageId, field, propertyValue));
      } else {
        field = _objectSpread(_objectSpread({}, field), updateFieldProperty(editingLanguageId, field, propertyName, propertyValue));
      }

      return field;
    };

    exports.updateField = updateField;
    //# sourceMappingURL=settingsContext.es.js.map
  }
});
//# sourceMappingURL=settingsContext.es.js.map