Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.55/js/components/LayoutProvider/util/rules.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../expressions/Token.es', '../../../expressions/Tokenizer.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.updateRulesReferences = exports.renameFieldInsideAutofill = exports.renameFieldInsideExpression = exports.isOptionReferencedByOperand = exports.isFieldValueOperand = exports.isEqualLengthOptions = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _Token = _interopRequireDefault(require("../../../expressions/Token.es"));

    var _Tokenizer = _interopRequireDefault(require("../../../expressions/Tokenizer.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var isEqualLengthOptions = function isEqualLengthOptions(options1, options2) {
      if (!!options1 && !!options2) {
        return options1.length === options2.length;
      } else {
        return false;
      }
    };

    exports.isEqualLengthOptions = isEqualLengthOptions;

    var isFieldValueOperand = function isFieldValueOperand(operands) {
      return operands.length == 2 && operands[0].type === 'field' && operands[1].type == 'string';
    };

    exports.isFieldValueOperand = isFieldValueOperand;

    var isOptionReferencedByOperand = function isOptionReferencedByOperand(options, operandValue) {
      return options.some(function (_ref) {
        var label = _ref.label;
        return operandValue === label;
      });
    };

    exports.isOptionReferencedByOperand = isOptionReferencedByOperand;

    var renameFieldInsideExpression = function renameFieldInsideExpression(expression, fieldName, newFieldName) {
      var tokens = _Tokenizer.default.tokenize(expression);

      return _Tokenizer.default.stringifyTokens(tokens.map(function (token) {
        if (token.type === _Token.default.VARIABLE && token.value === fieldName) {
          token = new _Token.default(_Token.default.VARIABLE, newFieldName);
        }

        return token;
      }));
    };

    exports.renameFieldInsideExpression = renameFieldInsideExpression;

    var renameFieldInsideAutofill = function renameFieldInsideAutofill(object, oldFieldName, newFieldName) {
      Object.keys(object).map(function (key) {
        if (object[key] === oldFieldName) {
          object[key] = newFieldName;
        }
      });
      return object;
    };

    exports.renameFieldInsideAutofill = renameFieldInsideAutofill;

    var updateRulesReferences = function updateRulesReferences(rules, oldProperties, newProperties) {
      var oldFieldName = oldProperties.fieldName;
      var newFieldName = newProperties.fieldName;
      var visitor = new _dynamicDataMappingFormRenderer.RulesVisitor(rules);
      rules = visitor.mapActions(function (action) {
        if (action.target === oldFieldName) {
          action = _objectSpread(_objectSpread({}, action), {}, {
            target: newFieldName
          });
        }

        if (action.action === 'calculate') {
          action = _objectSpread(_objectSpread({}, action), {}, {
            expression: renameFieldInsideExpression(action.expression, oldFieldName, newFieldName)
          });
        } else if (action.action === 'auto-fill') {
          action = _objectSpread(_objectSpread({}, action), {}, {
            inputs: renameFieldInsideAutofill(action.inputs, oldFieldName, newFieldName),
            outputs: renameFieldInsideAutofill(action.outputs, oldFieldName, newFieldName)
          });
        }

        return action;
      });
      visitor.setRules(rules);
      return visitor.mapConditions(function (condition) {
        return _objectSpread(_objectSpread({}, condition), {}, {
          operands: condition.operands.map(function (operand, index) {
            var oldOptions = oldProperties.options;
            var newOptions = newProperties.options;

            if (operand.type === 'field' && operand.value === oldFieldName) {
              return _objectSpread(_objectSpread({}, operand), {}, {
                value: newFieldName
              });
            } else if (index === 1 && isFieldValueOperand(condition.operands) && isEqualLengthOptions(oldOptions, newOptions) && isOptionReferencedByOperand(oldOptions, operand.value)) {
              var changedOption = newOptions.find(function (_ref2) {
                var value = _ref2.value;
                return value === oldOptions.find(function (_ref3) {
                  var label = _ref3.label;
                  return label === operand.value;
                }).value;
              });

              if (changedOption) {
                return _objectSpread(_objectSpread({}, operand), {}, {
                  value: changedOption.label
                });
              }
            }

            return operand;
          })
        });
      });
    };

    exports.updateRulesReferences = updateRulesReferences;
    //# sourceMappingURL=rules.es.js.map
  }
});
//# sourceMappingURL=rules.es.js.map