Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.55/js/components/LayoutProvider/handlers/fieldSetAddedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../util/fieldset.es', '../util/settingsContext.es', './fieldAddedHandler.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _fieldset = require("../util/fieldset.es");

    var _settingsContext = require("../util/settingsContext.es");

    var _fieldAddedHandler = require("./fieldAddedHandler.es");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var handleFieldSetAdded = function handleFieldSetAdded(props, state, event) {
      var defaultLanguageId = event.defaultLanguageId,
          fieldSet = event.fieldSet,
          indexes = event.indexes,
          parentFieldName = event.parentFieldName,
          properties = event.properties,
          rows = event.rows,
          useFieldName = event.useFieldName;
      var pages = state.pages;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(fieldSet.pages);
      var nestedFields = [];
      visitor.mapFields(function (nestedField) {
        nestedFields.push((0, _settingsContext.updateField)(props, nestedField, 'label', nestedField.label[defaultLanguageId]));
      });
      var fieldSetField = (0, _fieldset.createFieldSet)(props, {
        skipFieldNameGeneration: false,
        useFieldName: useFieldName
      }, nestedFields);

      if (properties) {
        Object.keys(properties).forEach(function (key) {
          fieldSetField = (0, _settingsContext.updateField)(props, fieldSetField, key, properties[key]);
        });
      }

      if (fieldSet.id) {
        fieldSetField = (0, _settingsContext.updateField)(props, fieldSetField, 'ddmStructureId', fieldSet.id);
      }

      if (rows && rows.length) {
        fieldSetField = (0, _settingsContext.updateField)(props, fieldSetField, 'rows', rows);
      }

      return (0, _fieldAddedHandler.addField)(props, {
        indexes: indexes,
        newField: (0, _settingsContext.updateField)(props, fieldSetField, 'label', fieldSet.localizedTitle[defaultLanguageId]),
        pages: pages,
        parentFieldName: parentFieldName
      });
    };

    var _default = handleFieldSetAdded;
    exports.default = _default;
    //# sourceMappingURL=fieldSetAddedHandler.es.js.map
  }
});
//# sourceMappingURL=fieldSetAddedHandler.es.js.map