/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {updateField, updateFieldReference} from '../util/settingsContext.es';
import {findInvalidFieldReference, updateState} from './fieldEditedHandler.es';

export const handleFieldBlurred = (props, state, event) => {
	let newState = {
		fieldHovered: {},
		pages: state.pages,
	};

	if (event) {
		const {propertyName, propertyValue} = event;

		if (propertyName === 'name' && propertyValue === '') {
			newState = updateField(state, propertyName, propertyValue);
		}

		if (
			propertyName === 'fieldReference' &&
			(propertyValue === '' ||
				findInvalidFieldReference(
					state.focusedField,
					state.pages,
					propertyValue
				))
		) {
			newState = updateState(
				props,
				{
					...state,
					focusedField: updateFieldReference(
						state.focusedField,
						false,
						true
					),
				},
				propertyName,
				state.focusedField.fieldName
			);
		}
	}

	return newState;
};

export default handleFieldBlurred;
