/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import dom from 'metal-dom';
import {EventHandler} from 'metal-events';
import Component from 'metal-jsx';

import formBuilderProps from './props.es';

const withClickableFields = (ChildComponent) => {
	class ClickableFields extends Component {
		attached() {
			this._eventHandler = new EventHandler();

			this._eventHandler.add(
				this.delegate(
					'click',
					'.ddm-field-container',
					this._handleFieldClicked.bind(this)
				)
			);
		}

		disposed() {
			this._eventHandler.removeAllListeners();
		}

		render() {
			return <ChildComponent {...this.props} />;
		}

		_handleFieldClicked(event) {
			const {delegateTarget} = event;
			const {dispatch} = this.context;
			const {fieldName} = delegateTarget.dataset;
			let {activePage} = this.context.store.state;

			event.stopPropagation();
			if (
				!event.delegateTarget.children[1].hasAttribute('aria-grabbed')
			) {
				activePage = parseInt(
					dom.closest(event.delegateTarget, '[data-ddm-page]').dataset
						.ddmPage,
					10
				);
			}

			dispatch('fieldClicked', {activePage, fieldName});
		}
	}

	ClickableFields.PROPS = {
		...formBuilderProps,
	};

	return ClickableFields;
};

export default withClickableFields;
