/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {compose} from 'dynamic-data-mapping-form-renderer';
import Component from 'metal-jsx';
import {Config} from 'metal-state';

import LayoutProvider from '../LayoutProvider/LayoutProvider.es';
import {FormBuilderBase} from './FormBuilder.es';
import withActionableFields from './withActionableFields.es';
import withClickableFields from './withClickableFields.es';
import withEditablePageHeader from './withEditablePageHeader.es';
import withMoveableFields from './withMoveableFields.es';
import withMultiplePages from './withMultiplePages.es';
import withResizeableColumns from './withResizeableColumns.es';

/**
 * LayoutProvider listens to your children's events to
 * control the `pages` and make manipulations.
 * @extends Component
 */

class FormBuilderWithLayoutProvider extends Component {
	render() {
		const {formBuilderProps, layoutProviderProps} = this.props;

		const LProvider = LayoutProvider;

		const composeList = [
			withActionableFields,
			withClickableFields,
			withMoveableFields,
			withResizeableColumns,
		];

		if (layoutProviderProps.allowMultiplePages) {
			composeList.push(withMultiplePages);
			composeList.push(withEditablePageHeader);
		}

		const FBuilder = compose(...composeList)(FormBuilderBase);

		return (
			<LProvider {...layoutProviderProps}>
				<FBuilder {...formBuilderProps} />
			</LProvider>
		);
	}
}

FormBuilderWithLayoutProvider.PROPS = {
	formBuilderProps: Config.object(),
	layoutProviderProps: Config.object(),
};

export default FormBuilderWithLayoutProvider;
