Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.4/js/components/FormBuilder/withResizeableColumns.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state', '../../util/config.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _config = require("../../util/config.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var withResizeableColumns = function withResizeableColumns(ChildComponent) {
    var ResizeableColumns =
    /*#__PURE__*/
    function (_Component) {
      _inherits(ResizeableColumns, _Component);

      function ResizeableColumns() {
        _classCallCheck(this, ResizeableColumns);

        return _possibleConstructorReturn(this, _getPrototypeOf(ResizeableColumns).apply(this, arguments));
      }

      _createClass(ResizeableColumns, [{
        key: "attached",
        value: function attached() {
          this._createResizeDrag();
        }
      }, {
        key: "disposeInternal",
        value: function disposeInternal() {
          _get(_getPrototypeOf(ResizeableColumns.prototype), "disposeInternal", this).call(this);

          if (this._resizeDrag) {
            this._resizeDrag.dispose();
          }
        }
      }, {
        key: "isResizeEnabled",
        value: function isResizeEnabled() {
          var _this$props = this.props,
              defaultLanguageId = _this$props.defaultLanguageId,
              editingLanguageId = _this$props.editingLanguageId;
          return defaultLanguageId === editingLanguageId;
        }
      }, {
        key: "render",
        value: function render() {
          IncrementalDOM.elementOpen("div", null, null, "class", this.isResizeEnabled() ? 'resizeable' : '');
          iDOMHelpers.renderArbitrary(this.renderResizeReferences());
          IncrementalDOM.elementOpenStart(ChildComponent);
          iDOMHelpers.forOwn(this.props, iDOMHelpers.attr);
          IncrementalDOM.elementOpenEnd(ChildComponent);
          IncrementalDOM.elementClose(ChildComponent);
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "renderResizeReferences",
        value: function renderResizeReferences() {
          return _toConsumableArray(Array(12)).map(function (element, index) {
            return IncrementalDOM.elementVoid("div", index, ["class", "ddm-resize-column", "key", index], "data-resize-column", index, "ref", "resizeColumn".concat(index));
          });
        }
      }, {
        key: "_createResizeDrag",
        value: function _createResizeDrag() {
          this._resizeDrag = new _metalDragDrop.Drag({
            axis: 'x',
            sources: '.resizeable .ddm-resize-handle',
            useShim: true
          });

          this._resizeDrag.on(_metalDragDrop.Drag.Events.END, this._handleDragEnd.bind(this));

          this._resizeDrag.on(_metalDragDrop.Drag.Events.DRAG, this._handleDragMove.bind(this));

          this._resizeDrag.on(_metalDragDrop.Drag.Events.START, this._handleDragStart.bind(this));
        }
      }, {
        key: "_handleDragEnd",
        value: function _handleDragEnd(_ref) {
          var source = _ref.source;
          var parentElement = source.parentElement;

          if (parentElement) {
            parentElement.classList.remove('dragging');
          }
        }
      }, {
        key: "_handleDragStart",
        value: function _handleDragStart() {
          this._lastResizeColumn = -1;
        }
      }, {
        key: "_handleDragMove",
        value: function _handleDragMove(event) {
          var _this = this;

          var columnNodes = Object.keys(this.refs).filter(function (key) {
            return key.indexOf('resizeColumn') === 0;
          }).map(function (key) {
            return _this.refs[key];
          });
          var source = event.source,
              x = event.x;
          var store = this.context.store;

          var container = _metalDom["default"].closest(source, '.ddm-field-container');

          if (container) {
            container.classList.add('dragging');
          }

          var distance = Infinity;
          var nearest;
          columnNodes.forEach(function (node) {
            var region = _metalPosition["default"].getRegion(node);

            var currentDistance = Math.abs(x - region.left);

            if (currentDistance < distance) {
              distance = currentDistance;
              nearest = node;
            }
          });

          if (nearest) {
            var column = Number(nearest.dataset.resizeColumn);
            var direction = source.classList.contains('ddm-resize-handle-left') ? 'left' : 'right';

            if (this._lastResizeColumn !== column) {
              this._lastResizeColumn = column;
              store.emit('columnResized', {
                column: column,
                direction: direction,
                source: source
              });
            }
          }
        }
      }]);

      return ResizeableColumns;
    }(_metalJsx["default"]);

    ResizeableColumns.PROPS = {
      /**
       * @default
       * @instance
       * @memberof FormBuilder
       * @type {?number}
       */
      activePage: _metalState.Config.number().value(0),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      defaultLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      fieldSetDefinitionURL: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?(array|undefined)}
       */
      fieldSets: _metalState.Config.array().value([]),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?(array|undefined)}
       */
      fieldTypes: _metalState.Config.array().value([]),

      /**
       * @default {}
       * @instance
       * @memberof FormBuilder
       * @type {?object}
       */
      focusedField: _config.focusedFieldStructure.value({}),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?array<object>}
       */
      pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      paginationMode: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      portletNamespace: _metalState.Config.string().required(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {!string}
       */
      spritemap: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {object}
       */
      successPageSettings: _metalState.Config.shapeOf({
        body: _metalState.Config.object(),
        enabled: _metalState.Config.bool(),
        title: _metalState.Config.object()
      }).value({}),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      view: _metalState.Config.string()
    };
    return ResizeableColumns;
  };

  var _default = withResizeableColumns;
  exports["default"] = _default;
  //# sourceMappingURL=withResizeableColumns.es.js.map
});
//# sourceMappingURL=withResizeableColumns.es.js.map