Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.11/js/components/LayoutProvider/handlers/fieldEditedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../util/focusedField.es', '../util/rules.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.handleFieldEdited = exports.updateField = exports.updatePages = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _focusedField = require("../util/focusedField.es");

  var _rules = require("../util/rules.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var updatePages = function updatePages(pages, oldFieldProperties, newFieldProperties) {
    var fieldName = oldFieldProperties.fieldName;
    return _dynamicDataMappingFormRenderer.FormSupport.updateField(pages, fieldName, newFieldProperties);
  };

  exports.updatePages = updatePages;

  var updateField = function updateField(props, state, fieldName, fieldValue) {
    var focusedField = state.focusedField,
        pages = state.pages,
        rules = state.rules;
    var updatedFocusedField = (0, _focusedField.updateFocusedField)(props, state, fieldName, fieldValue);
    return {
      focusedField: updatedFocusedField,
      pages: updatePages(pages, focusedField, updatedFocusedField),
      rules: (0, _rules.updateRulesReferences)(rules || [], focusedField, updatedFocusedField)
    };
  };

  exports.updateField = updateField;

  var handleFieldEdited = function handleFieldEdited(props, state, event) {
    var propertyName = event.propertyName,
        propertyValue = event.propertyValue;
    var newState = {};

    if (propertyName !== 'name' || propertyValue !== '') {
      newState = updateField(props, state, propertyName, propertyValue);
    }

    return newState;
  };

  exports.handleFieldEdited = handleFieldEdited;
  var _default = handleFieldEdited;
  exports["default"] = _default;
  //# sourceMappingURL=fieldEditedHandler.es.js.map
});
//# sourceMappingURL=fieldEditedHandler.es.js.map