"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.9/js/util/fieldSupport.es", ['module', 'exports', 'require', './visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getFieldProperties = exports.normalizeSettingsContextPages = exports.generateInstanceId = exports.formatFieldName = void 0;

  var _visitors = require("./visitors.es");

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var formatFieldName = function formatFieldName(instanceId, languageId, value) {
    return "ddm$$".concat(value, "$").concat(instanceId, "$0$$").concat(languageId);
  };

  exports.formatFieldName = formatFieldName;

  var generateInstanceId = function generateInstanceId(length) {
    var text = '';
    var possible = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

    for (var i = 0; i < length; i++) {
      text += possible.charAt(Math.floor(Math.random() * possible.length));
    }

    return text;
  };

  exports.generateInstanceId = generateInstanceId;

  var normalizeSettingsContextPages = function normalizeSettingsContextPages(pages, editingLanguageId, fieldType, generatedFieldName) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapFields(function (field) {
      var _field = field,
          fieldName = _field.fieldName;

      if (fieldName === 'name') {
        field = _objectSpread({}, field, {
          value: generatedFieldName,
          visible: true
        });
      } else if (fieldName === 'label') {
        field = _objectSpread({}, field, {
          localizedValue: _objectSpread({}, field.localizedValue, _defineProperty({}, editingLanguageId, fieldType.label)),
          type: 'text',
          value: fieldType.label
        });
      } else if (fieldName === 'type') {
        field = _objectSpread({}, field, {
          value: fieldType.name
        });
      } else if (fieldName === 'validation') {
        field = _objectSpread({}, field, {
          validation: _objectSpread({}, field.validation, {
            fieldName: generatedFieldName
          })
        });
      }

      return _objectSpread({}, field);
    });
  };

  exports.normalizeSettingsContextPages = normalizeSettingsContextPages;

  var getFieldProperties = function getFieldProperties(_ref, defaultLanguageId, editingLanguageId) {
    var pages = _ref.pages;
    var properties = {};
    var visitor = new _visitors.PagesVisitor(pages);
    visitor.mapFields(function (_ref2) {
      var fieldName = _ref2.fieldName,
          localizable = _ref2.localizable,
          localizedValue = _ref2.localizedValue,
          type = _ref2.type,
          value = _ref2.value;

      if (localizable && localizedValue[editingLanguageId] && localizedValue[editingLanguageId].JSONArray) {
        properties[fieldName] = localizedValue[editingLanguageId].JSONArray;
      } else if (localizable && localizedValue[editingLanguageId]) {
        properties[fieldName] = localizedValue[editingLanguageId];
      } else if (localizable && localizedValue[defaultLanguageId]) {
        properties[fieldName] = localizedValue[defaultLanguageId];
      } else if (type == 'options') {
        if (!value[editingLanguageId] && value[defaultLanguageId]) {
          properties[fieldName] = value[defaultLanguageId];
        } else {
          properties[fieldName] = value[editingLanguageId];
        }
      } else {
        properties[fieldName] = value;
      }
    });
    return properties;
  };

  exports.getFieldProperties = getFieldProperties;
  //# sourceMappingURL=fieldSupport.es.js.map
});
//# sourceMappingURL=fieldSupport.es.js.map